class PcFundraisers {

    init() {

        this.selector = {
            button: {
                clearFilter: '.pc-fr-clear-filter',
            },
            presentation: {
                container: '.pc-single-fundraiser-presentation-container',
                containerLoader: '.pc-single-fundraiser-presentation-container-loader',
                containerShortcode: '.pc-single-fundraiser-presentation-container-shortcode',
                closeButton: '.pc-single-fundraiser-presentation-container-shortcode-close-button',
            }
        };

        this.initEventHandlers();
        this.initPresentationContainer();
    }

    initEventHandlers() {

        jQuery(document).on('click', this.selector.button.clearFilter, this.handleClearFilter);
    }

    handleClearFilter(event) {
        event.preventDefault();

        const url = window.location.href.split('?')[0];
        window.location = url;

        return undefined;
    }

    initPresentationContainer() {

        const url = new URL(window.location.href);
        const fundraiserSlug = url.searchParams.get('fundraiser');

        if (
            typeof fundraiserSlug === 'undefined' ||
            !fundraiserSlug
        ) { return; }

        const campaignId = url.searchParams.get('campaign');

        if (
            typeof campaignId === 'undefined' ||
            !campaignId
        ) { return; }

        const presentationContainer = document.querySelector(`${window.PcFundraisers.selector.presentation.container}[data-fundraiser-slug="${fundraiserSlug}"][data-campaign-id="${campaignId}"]`);

        if (
            typeof presentationContainer === 'undefined' ||
            !presentationContainer
        ) { return; }

        presentationContainer.querySelector(window.PcFundraisers.selector.presentation.containerLoader).style.display = 'none';
        presentationContainer.querySelector(window.PcFundraisers.selector.presentation.containerShortcode).classList.add('active');

        presentationContainer.querySelector(window.PcFundraisers.selector.presentation.closeButton).addEventListener('click', (event) => {
            event.preventDefault();

            presentationContainer.remove();
        });
    }
}

window.PcFundraisers = new PcFundraisers;