core.js
=======

The `core.js` script is a vanilla JavaScript ES6 module that serves as an autoloader for other JavaScript modules. It's responsible for dynamically loading and initializing scripts based on conditions specified in the `autoload` array.

Global Variables
----------------

- `window.andromedaAutoloadDependencies`: An empty array to store the script dependencies.
- `window.breakpoints`: An object containing breakpoint values for different screen sizes.
- `window.autoload`: An array containing objects that describe which scripts should be loaded, when they should be loaded, and any dependencies they might have.
- `window.scriptsDir`: A string representing the directory path to the JavaScript files.

Functions
---------

- `window.loadScript(element)`: A function that takes a script element object, creates a new script tag with the provided `src`, `async`, and `onload` attributes, and appends it to the document body.
- `window.loadDependencyScript(dependency, id)`: A function that takes a dependency script name and its ID, creates a new script tag with the provided `src`, `async`, and `onload` attributes, and appends it to the document body. It's used for loading dependent scripts before loading the main script.

Usage
-----

The `core.js` script is executed automatically when the window is loaded. It iterates through the `window.autoload` array and checks the `loadWhen()` function for each script element. If the `loadWhen()` function returns `true`, the script is loaded.

If the script has dependencies specified in the `worksWith` property, the `loadDependencyScript()` function is called to load the dependencies first. Once all dependencies are loaded, the main script is loaded using the `loadScript()` function.

For example, to load the `PcSponsorships` module, you would add the following object to the `window.autoload` array:

```
{
    script: 'sponsorships',
    className: 'PcSponsorships',
    onload: () => {
        window.PcSponsorships.init();
    },
    loadWhen: () => {
        return (
            (
                typeof document.querySelector('.js-sponshorships-lazy-loaded') !== 'undefined' &&
                document.querySelector('.js-sponshorships-lazy-loaded')
            ) ||
            (
                typeof document.querySelector('.pc-single-view') !== 'undefined' &&
                document.querySelector('.pc-single-view')
            )
        );
    }
}

```

The `PcSponsorships` module will be loaded if either `.js-sponshorships-lazy-loaded` or `.pc-single-view` elements are present in the DOM. Once the script is loaded, the `init()` method of the `PcSponsorships` module will be called.