<?php

namespace PureCharity\Trips;

class PaginatorController extends TripsController {
    
    public $moduleConfig;

    const DEFAULT_PER_PAGE = 10;

    function __construct($moduleConfig) {

        $this->moduleConfig = $moduleConfig;
    }

    public static function pageLinks($meta = array(), $options = array()){
        if((int)$meta->num_pages == 1){
          return '';
        }
        $opts = self::sanitizeOptions($options);
    
        $html = '<div class="pc_pagination">';
        $html .= '<ul class="pc_page-numbers">';
    
        if($meta->current_page > 1){
          $html .= '<li><a class="pc_page-numbers" href="?_page='.($meta->current_page-1).'"><span class="dashicons dashicons-arrow-left-alt" style="transform: translateY(15%);"></span></a></li>';
        }
    
        $countIndex = (
          $meta->current_page > 10 ?
          $meta->current_page - 4 :
          1
        );
         
        $allPages = 0;
        for($i = $countIndex; $i <= $meta->num_pages; $i++){
         
          if ($allPages >= 10) { break; }
         
          if ($meta->current_page === $i) {
            $html .= '<li><span class="pc_page-numbers current">'.$i.'</span></li>';
          } else {
            $html .= '<li><a class="pc_page-numbers" href="?_page='.$i.'">'.$i.'</a></li>';
          }
         
          $allPages += 1;
        }
        
        if($meta->current_page < $meta->num_pages){
          $html .= '<li><a class="pc_page-numbers" href="?_page='.($meta->current_page+1).'"><span class="dashicons dashicons-arrow-right-alt" style="transform: translateY(15%);"></span></a></li>';
        }
    
        $html .= '</ul>';
        $html .= '</div>';
        
        return $html;
      }
    
      /**
       * Convert options into usable options.
       *
       * @since 1.0.0
       */
    public static function sanitizeOptions($options){
        $sanitized = array();
        foreach($options as $key => $value){
        if($key == '' || $value == ''){ continue; }
        $sanitized[$key] = $value;
        }
        if(!isset($sanitized['per_page'])){ $sanitized['per_page'] = self::DEFAULT_PER_PAGE; }
        
        return $sanitized;
      }
}