<?php

namespace PureCharity\Trips;

class LoaderController extends TripsController {

    public $moduleConfig;
    private $controllers;

    protected $extendedHooks;
    protected $actions;
    protected $filters;

    function __construct($moduleConfig) {

        $this->moduleConfig = $moduleConfig;

        $this->extendedHooks = [
            'wp_ajax',
            'wp_ajax_nopriv',
        ];

        $this->actions = [
            'admin_menu' => [
                'AdminController' => [
                    'addAdminMenu',
                ]
            ],
            'admin_init' => [
                'AdminController' => [
                    'settingsInit',
                ],
            ],
            'plugins_loaded' => [
                'I18nController' => [
                    'loadPluginTextdomain',
                ],
            ],
            // 'admin_enqueue_scripts' => [
            //     'AdminController' => [
            //         'enqueueStyles',
            //         'enqueueScripts',
            //     ],
            // ],
            'wp_enqueue_scripts' => [
                'PublicController' => [
                    // 'enqueueScripts',
                ],
            ],
            'template_redirect' => [
                'PublicController' => [
                    // 'gtForceTemplate',
                ],
            ],
            'wp_head' => [
                'PublicController' => [
                    'handleSingleTripPreview',
                ],
            ],
            'get_footer' => [
                'PublicController' => [
                    'enqueueStyles',
                ],
            ],
            'wp_ajax' => [
                'PublicController' => [
                    'purecharityTripsFiltering',
                ],
            ],
            'wp_ajax_nopriv' => [
                'PublicController' => [
                    'purecharityTripsFiltering',
                ],
            ],
        ];

        $this->filters = [];
    }

    public function init($controllers) {
        $this->controllers = $controllers;

        $this->initHooks($this->actions, false);
        $this->initHooks($this->filters, true);
    }

    private function initHooks($hooks, $isFilters = false) {

        foreach ($hooks as $hook => $config) {
            
            if (empty($config)) { continue; }

            foreach ($config as $controller => $actions) {

                if (empty($actions)) { continue; }

                $controllerClass = (
                    !empty($this->controllers[$controller]) ?
                    $this->controllers[$controller] :
                    null
                );

                if (empty($controllerClass)) { continue; }

                foreach ($actions as $index => $method) {
                    
                    $hookWorkable = $hook;

                    if (in_array($hook, $this->extendedHooks)) {

                        $hookWorkable .= '_'. $method;
                    }

                    if (!$isFilters) {
                        add_action(
                            $hookWorkable,
                            [
                                $controllerClass,
                                $method
                            ]
                        );
                    } else {
                        add_filter(
                            $hookWorkable,
                            [
                                $controllerClass,
                                $method
                            ]
                        );
                    }
                }
            }
        }
    }
}