<?php

namespace PureCharity\Trips;

class AdminController extends TripsController {

    public $moduleConfig;
    private $version;
    private $pluginName;
    
    public static $classPath = '\PureCharity\Trips\AdminController';

    function __construct($moduleConfig) {
        
        $this->moduleConfig = $moduleConfig;
    
        $this->pluginName = $this->moduleConfig['plugin']['name'];
        $this->version = $this->moduleConfig['plugin']['version'];
    }
	
	function addAdminMenu() { 

		add_options_page(
            'PureCharity&#8482; Trips Settings', 
            'PureCharity&#8482; Trips', 
            'manage_options', 
            'pure_plugin_trips', 
            [$this, 'optionsPage']
        );
	}

	/**
	 * Checks for the existence of the pure base settings.
	 *
	 * @since 1.0.0
	 */
	public static function settingsExist() { 
		if (false == get_option('purecharity_plugin_trips_settings')) { 
			add_option('purecharity_plugin_trips_settings');
		}
	}

	/**
	 * Initializes the settings page options.
	 *
	 * @since 1.0.0
	 */
	public static function settingsInit() 
	{
		register_setting( 'ptPluginPage', 'purecharity_plugin_trips_settings' );

		add_settings_section(
			'purecharity_trips_ptPluginPage_section', 
			__( 'General settings', 'wordpress' ), 
			[self::$classPath, 'settingsSectionCallback'],
			'ptPluginPage'
		);

		add_settings_field( 
			'plugin_color', 
			__( 'Main Theme Color', 'wordpress' ), 
			[self::$classPath, 'mainColorRender'],
			'ptPluginPage', 
			'purecharity_trips_ptPluginPage_section' 
		);

		if (!self::$disableLiveSearch) {
			add_settings_field( 
				'live_filter', __( 'Display Live Filter', 'wordpress' ), 
				[self::$classPath, 'liveFilterRender'],
				'ptPluginPage', 
				'purecharity_trips_ptPluginPage_section' 
			);
		}

		add_settings_field( 
			'single_view_template', __( 'Single view template', 'wordpress' ), 
			[self::$classPath, 'singleViewTemplateRender'],
			'ptPluginPage', 
			'purecharity_trips_ptPluginPage_section' 
		);
	}

	/**
	 * Renders the color picker for main color.
	 *
	 * @since 1.0.0
	 */
	public static function mainColorRender()
	{ 
		$options = get_option( 'purecharity_plugin_trips_settings' );
		?>
		<input type="text" id="main_color" name="purecharity_plugin_trips_settings[main_color]" value="<?php echo @$options['main_color']; ?>">
		<?php
	}

	/**
	 * Callback for use with Settings API.
	 *
	 * @since 1.0.0
	 */
	public static function settingsSectionCallback() 
	{ 
		echo __( 'General settings for the Pure Charity Trips module.', 'wordpress' );
	}

	
	/**
	 * Creates the options page.
	 *
	 * @since 1.0.0
	 */
	public static function optionsPage()
	{
    ?>
    <div class="wrap">
      <form action="options.php" method="post" class="pure-settings-form">
				<?php
					echo '<img align="left" src="' . plugins_url( 'purecharity-plugin/resources/assets/img/purecharity.png' ) . '" > ';
				?>
				<h2 style="padding-left:100px;padding-top: 20px;padding-bottom: 50px;border-bottom: 1px solid #ccc;">PureCharity&#8482; Trips Settings</h2>
				
				<?php
				settings_fields( 'ptPluginPage' );
				do_settings_sections( 'ptPluginPage' );
				submit_button();
				?>
				
			</form>
    </div>
    <?php
	}

	public static function liveFilterRender() {
		$options = get_option( 'purecharity_plugin_trips_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_trips_settings[live_filter]" 
			<?php echo (isset($options['live_filter'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	public static function singleViewTemplateRender() {
		$options = get_option( 'purecharity_plugin_trips_settings' );
		
		global $PcPlugin;
		$baseModule = $PcPlugin->getModule('base', 'BaseController');
		$templates = $baseModule->purecharityGetTemplates();
		?>
		<select name="purecharity_plugin_trips_settings[single_view_template]">
			<option value="">Inherit from the listing page</option>
			<?php foreach($templates as $key => $template){ ?>
				<option <?php echo $template == @$options['single_view_template'] ? 'selected' : '' ?> value="<?php echo $template; ?>"><?php echo "$key ($template)" ?></option>
			<?php } ?>
		</select>
		<?php
	}
}