<?php

namespace PureCharity\GivingCircles;

class ShortcodeController extends GivingCirclesController {
    
    public $moduleConfig;

    private $config;

    public static $classPath = '\PureCharity\GivingCircles\ShortcodeController';

    function __construct($moduleConfig) {

        $this->moduleConfig = $moduleConfig;

        $this->config = [
            'shortcodes' => [
                'giving_circles' => 'givingCirclesShortcode',
                'giving_circle' => 'givingCircleShortcode',
                'giving_circle_info' => 'givingCircleInfoShortcode',
            ],
        ];

        $this->init();
    }

    public function init() {

        $this->registerShortcodes();
    }

    public function registerShortcodes() {

        if (empty($this->config['shortcodes'])) { return false; }

        foreach ($this->config['shortcodes'] as $shortcodeId => $shortcodeMethod) {

            if (
                empty($shortcodeId) ||
                empty($shortcodeMethod)
            ) { continue; }
              
            add_shortcode(
                $shortcodeId,
                [
                  self::$classPath,
                  $shortcodeMethod
                ]
            );
        }
    }

    public static function givingCirclesShortcode($atts) {
        self::handleModuleResource('giving-circles', true);

        $options = shortcode_atts( array(
            'members_limit' => get_query_var('members_limit'),
            'backed_limit' => get_query_var('backed_limit')
        ), $atts );

        global $PcPlugin;

        $baseModule = $PcPlugin->getModule('base', 'BaseController');
        $apiController = $baseModule->getController('ApiController');

		$givingCirclesModule = $PcPlugin->getModule('giving-circles', 'GivingCirclesController');
		$publicController = $givingCirclesModule->getController('PublicController');

        $publicController::$options = $options;

        if(isset($_GET['giving_circle'])){
            // Todo: Connect the Single Giving Circle Shortcode
            // $options = array();
            // $options["giving_circle"] = $_GET['giving_circle'];
            // return self::giving_circle_shortcode($options);
        }else{
            $givingcircles = $apiController->apiCall(
                'givingcircles',
                [],
                []
            );

            if (empty($givingcircles)) {
                return $publicController::listNotFound();
            }

            // Todo: Connect the Giving Circles API + Listing
            // $givingcircles = self::$base_plugin->api_call('giving_circles');
      
            // if ($givingcircles && count($givingcircles->giving_circles) > 0) {
            //   $givingcircles = $givingcircles->giving_circles;
            //   Purecharity_Wp_Givingcircles_Public::$givingcircles = $givingcircles;
            //   return Purecharity_Wp_Givingcircles_Public::listing();
            // }else{
            //   return Purecharity_Wp_Givingcircles_Public::list_not_found();        
            // };
        }
    }

    public static function givingCircleShortcode($atts) {
        // Todo: Migrate functionalities
    }

    public static function givingCircleInfoShortcode($atts) {
        // Todo: Migrate functionalities
    }
}