<?php

namespace PureCharity\GivingCircles;

use \stdClass;

class PublicController extends GivingCirclesController {

    public $moduleConfig;

	public static $options;
	public static $givingcircle;
	public static $givingcircles;

    private $version;
    private $pluginName;
    
    public static $classPath = '\PureCharity\GivingCircles\PublicController';

    function __construct($moduleConfig) {
        $this->moduleConfig = $moduleConfig;
    
        $this->pluginName = $this->moduleConfig['plugin']['name'];
        $this->version = $this->moduleConfig['plugin']['version'];
    }

    /**
	 * Register the stylesheets for the Dashboard.
	 *
	 * @since 1.0.0
	 */
	public function enqueueStyles() 
	{

		if (self::moduleResourceExists('giving-circles')) {
		
			wp_enqueue_style(
				'purecharity-plugin-giving-circles-public', 
				$this->moduleConfig['resources']['styles'] .'public/giving-circles.css', 
				[], 
				$this->version, 
				'all'
			);

			self::handleModuleResource('giving-circles', false);
		}
	}

    /**
	 * Register the JavaScript for the dashboard.
	 *
	 * @since 1.0.0
	 */
	public function enqueueScripts($hook) 
	{
	}

	/**
	 * Not found layout for listing display.
	 *
	 * @since    1.0.0
	 */
	public static function listNotFound(){
		$html = "<p class='text-center'>No Giving Circles Found.</p>" . \PureCharity\Base\PublicController::poweredBy();
		return $html;
	}
}