<?php

namespace PureCharity\GivingCircles;

class AdminController extends GivingCirclesController {

    public $moduleConfig;
    private $version;
    private $pluginName;
    
    public static $classPath = '\PureCharity\GivingCircles\AdminController';

    function __construct($moduleConfig) {
        
        $this->moduleConfig = $moduleConfig;
    
        $this->pluginName = $this->moduleConfig['plugin']['name'];
        $this->version = $this->moduleConfig['plugin']['version'];
    }
	
	function addAdminMenu() { 

		add_options_page(
            'PureCharity&#8482; Giving Circles Settings', 
            'PureCharity&#8482; Giving Circles', 
            'manage_options', 
            'pure_plugin_giving_circles', 
            [$this, 'optionsPage']
        );
	}

	/**
	 * Checks for the existence of the pure base settings.
	 *
	 * @since 1.0.0
	 */
	public static function settingsExist() { 
		if (false == get_option('purecharity_plugin_giving_circles_settings')) { 
			add_option('purecharity_plugin_giving_circles_settings');
		}
	}

	/**
	 * Initializes the settings page options.
	 *
	 * @since 1.0.0
	 */
	public static function settingsInit() 
	{
		register_setting( 'pgcPluginPage', 'purecharity_plugin_giving_circles_settings' );

		add_settings_section(
			'purecharity_giving_circles_pgcPluginPage_section', 
			__( 'General settings', 'wordpress' ), 
			[self::$classPath, 'settingsSectionCallback'],
			'pgcPluginPage'
		);

		add_settings_field( 
			'plugin_color', 
			__( 'Main Theme Color', 'wordpress' ), 
			[self::$classPath, 'mainColorRender'],
			'pgcPluginPage', 
			'purecharity_giving_circles_pgcPluginPage_section' 
		);

		add_settings_field( 
			'round_avatars', __( 'Round Avatar Images', 'wordpress' ), 
			[self::$classPath, 'roundAvatarsRender'],
			'pgcPluginPage', 
			'purecharity_giving_circles_pgcPluginPage_section' 
		);
		
		add_settings_field( 
			'single_view_template', __( 'Single view template', 'wordpress' ), 
			[self::$classPath, 'singleViewTemplateRender'],
			'pgcPluginPage', 
			'purecharity_giving_circles_pgcPluginPage_section' 
		);
	}

	/**
	 * Renders the color picker for main color.
	 *
	 * @since 1.0.0
	 */
	public static function mainColorRender()
	{ 
		$options = get_option( 'purecharity_plugin_giving_circles_settings' );
		?>
		<input type="text" id="main_color" name="purecharity_plugin_giving_circles_settings[plugin_color]" value="<?php echo @$options['plugin_color']; ?>">
		<?php
	}

	/**
	 * Callback for use with Settings API.
	 *
	 * @since 1.0.0
	 */
	public static function settingsSectionCallback() 
	{ 
		echo __( 'General settings for the Pure Charity Giving Circles module.', 'wordpress' );
	}

	
	/**
	 * Creates the options page.
	 *
	 * @since 1.0.0
	 */
	public static function optionsPage()
	{
    ?>
    <div class="wrap">
      <form action="options.php" method="post" class="pure-settings-form">
				<?php
					echo '<img align="left" src="' . plugins_url( 'purecharity-plugin/resources/assets/img/purecharity.png' ) . '" > ';
				?>
				<h2 style="padding-left:100px;padding-top: 20px;padding-bottom: 50px;border-bottom: 1px solid #ccc;">PureCharity&#8482; Giving Circles Settings</h2>
				
				<?php
				settings_fields( 'pgcPluginPage' );
				do_settings_sections( 'pgcPluginPage' );
				submit_button();
				?>
				
			</form>
    </div>
    <?php
	}

	/**
	 * Renders the round avatar image switch.
	 *
	 * @since 1.0.0
	 */
	public static function roundAvatarsRender() { 
		$options = get_option( 'purecharity_plugin_giving_circles_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_giving_circles_settings[round_avatars]" 
			<?php echo (isset($options['round_avatars'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	public static function singleViewTemplateRender() {
		$options = get_option( 'purecharity_plugin_giving_circles_settings' );
		
		global $PcPlugin;
		$baseModule = $PcPlugin->getModule('base', 'BaseController');
		$templates = $baseModule->purecharityGetTemplates();
		?>
		<select name="purecharity_plugin_giving_circles_settings[single_view_template]">
			<option value="">Inherit from the listing page</option>
			<?php foreach($templates as $key => $template){ ?>
				<option <?php echo $template == @$options['single_view_template'] ? 'selected' : '' ?> value="<?php echo $template; ?>"><?php echo "$key ($template)" ?></option>
			<?php } ?>
		</select>
		<?php
	}
}