<?php

namespace PureCharity\Fundraisers;

class AdminController extends FundraisersController {

    public $moduleConfig;
    private $version;
    private $pluginName;
    
    public static $classPath = '\PureCharity\Fundraisers\AdminController';

    function __construct($moduleConfig) {
        
        $this->moduleConfig = $moduleConfig;
    
        $this->pluginName = $this->moduleConfig['plugin']['name'];
        $this->version = $this->moduleConfig['plugin']['version'];
    }
	
	function addAdminMenu() { 

		add_options_page(
            'PureCharity&#8482; Fundraisers Settings', 
            'PureCharity&#8482; Fundraisers', 
            'manage_options', 
            'pure_plugin_fundraisers', 
            [$this, 'optionsPage']
        );
	}

	/**
	 * Checks for the existence of the pure base settings.
	 *
	 *
	 */
	public static function settingsExist() { 
		if (false == get_option('purecharity_plugin_fundraisers_settings')) { 
			add_option('purecharity_plugin_fundraisers_settings');
		}
	}

	/**
	 * Initializes the settings page options.
	 *
	 *
	 */
	public static function settingsInit() 
	{
		register_setting( 'pfPluginPage', 'purecharity_plugin_fundraisers_settings' );

		add_settings_section(
			'purecharity_fundraisers_pfPluginPage_section', 
			__( 'General settings', 'wordpress' ), 
			[self::$classPath, 'settingsSectionCallback'],
			'pfPluginPage'
		);

		add_settings_field( 
			'plugin_color', 
			__( 'Main Theme Color', 'wordpress' ), 
			[self::$classPath, 'mainColorRender'],
			'pfPluginPage', 
			'purecharity_fundraisers_pfPluginPage_section' 
		);

		add_settings_field( 
			'single_view_template', 
			__( 'Single view template', 'wordpress' ), 
			[self::$classPath, 'singleViewTemplateRender'],
			'pfPluginPage', 
			'purecharity_fundraisers_pfPluginPage_section' 
		);

		add_settings_section(
			'purecharity_fundraisers_display_pfPluginPage_section', 
			__( 'Display settings', 'wordpress' ), 
			[self::$classPath, 'displaySettingsSectionCallback'],
			'pfPluginPage'
		);

		add_settings_field( 
			'live_filter', __( 'Display Filter', 'wordpress' ), 
			[self::$classPath, 'liveFilterRender'],
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);

		add_settings_field( 
			'fundraise_cause', __( 'Hide "Fundraise for this cause" link', 'wordpress' ), 
			[self::$classPath, 'fundraiseCauseRender'], 
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);

		add_settings_field( 
			'backers_tab', __( 'Hide the Backers Tab', 'wordpress' ), 
			[self::$classPath, 'backersTabRender'], 
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);

		add_settings_field( 
			'updates_tab', __( 'Hide the Updates Tab', 'wordpress' ), 
			[self::$classPath, 'updatesTabRender'], 
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);

		add_settings_field( 
			'days_to_go', __( 'Hide Days to Go', 'wordpress' ), 
			[self::$classPath, 'daysToGoRender'], 
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);

		add_settings_field( 
			'powered_by_pure_charity', __( 'Hide Powered by Pure Charity', 'wordpress' ), 
			[self::$classPath, 'poweredByPureCharityRender'], 
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);
		
		add_settings_field( 
			'organized_by', __( 'Hide Organized By', 'wordpress' ), 
			[self::$classPath, 'organizedByRender'], 
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);
		
		add_settings_field( 
			'map_icon', __( 'Hide Map Icon', 'wordpress' ), 
			[self::$classPath, 'mapIconRender'], 
			'pfPluginPage', 
			'purecharity_fundraisers_display_pfPluginPage_section' 
		);		
	}

	/**
	 * Renders the color picker for main color.
	 *
	 *
	 */
	public static function mainColorRender()
	{ 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>

		<input type="text" id="main_color" name="purecharity_plugin_fundraisers_settings[main_color]" value="<?php echo @$options['main_color']; ?>">
		
		<?php
	}

	/**
	 * Callback for use with Settings API.
	 *
	 *
	 */
	public static function settingsSectionCallback() 
	{ 
		echo __( 'General settings for the Pure Charity Fundraisers module.', 'wordpress' );
	}

	
	/**
	 * Creates the options page.
	 *
	 *
	 */
	public static function optionsPage()
	{
    ?>
    <div class="wrap">
      <form action="options.php" method="post" class="pure-settings-form">
				<?php
					echo '<img align="left" src="' . plugins_url( 'purecharity-plugin/resources/assets/img/purecharity.png' ) . '" > ';
				?>
				<h2 style="padding-left:100px;padding-top: 20px;padding-bottom: 50px;border-bottom: 1px solid #ccc;">PureCharity&#8482; Fundraisers Settings</h2>
				
				<?php
				settings_fields( 'pfPluginPage' );
				do_settings_sections( 'pfPluginPage' );
				submit_button();
				?>
				
			</form>
    </div>
    <?php
	}

	/**
	 * Renders the Live Filter Checkbox
	 *
	 *
	 */
	public static function liveFilterRender() {
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[live_filter]" 
			<?php echo (isset($options['live_filter'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	/**
	 * Renders the Single View Template Selector
	 *
	 *
	 */
	public static function singleViewTemplateRender() {
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		
		global $PcPlugin;
		$baseModule = $PcPlugin->getModule('base', 'BaseController');
		$templates = $baseModule->purecharityGetTemplates();
		?>
		<select name="purecharity_plugin_fundraisers_settings[single_view_template]">
			<option value="">Inherit from the listing page</option>
			<?php foreach($templates as $key => $template){ ?>
				<option <?php echo $template == @$options['single_view_template'] ? 'selected' : '' ?> value="<?php echo $template; ?>"><?php echo "$key ($template)" ?></option>
			<?php } ?>
		</select>
		<?php
	}

	/**
	 *
	 *
	 *
	 */
	public static function displaySettingsSectionCallback() {
		echo __( 'Display settings for the Pure Charity Fundraisers module.', 'wordpress' );
	}

	/**
	 * Renders the fundraise for this cause.
	 *
	 *
	 */
	public static function fundraiseCauseRender(  ) { 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[fundraise_cause]" 
			<?php echo (isset($options['fundraise_cause'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	/**
	 * Renders the backers tab.
	 *
	 *
	 */
	public static function backersTabRender(  ) { 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[backers_tab]" 
			<?php echo (isset($options['backers_tab'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	/**
	 * Renders the updates tab.
	 *
	 *
	 */
	public static function updatesTabRender(  ) { 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[updates_tab]" 
			<?php echo (isset($options['updates_tab'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	/**
	 * Renders the Days to Go.
	 *
	 *
	 */
	public static function daysToGoRender(  ) { 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[days_to_go]" 
			<?php echo (isset($options['days_to_go'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	/**
	 * Renders the Powered by Pure Charity field.
	 *
	 *
	 */
	public static function poweredByPureCharityRender(  ) { 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[powered_by_pure_charity]" 
			<?php echo (isset($options['powered_by_pure_charity'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	/**
	 * Renders the Organized By field.
	 *
	 *
	 */
	public static function organizedByRender(  ) { 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[organized_by]" 
			<?php echo (isset($options['organized_by'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}

	/**
	 * Renders the Map Icon field.
	 *
	 *
	 */
	public static function mapIconRender(  ) { 
		$options = get_option( 'purecharity_plugin_fundraisers_settings' );
		?>
		<input 
			type="checkbox" 
			name="purecharity_plugin_fundraisers_settings[map_icon]" 
			<?php echo (isset($options['map_icon'])) ? 'checked' : '' ?>
			value="true">
		<?php
	}
}