ConfigurationController
=======================

The `ConfigurationController.php` is a controller within the `BaseController.php` module, responsible for managing configuration settings and filters for the Pure Charity plugin.

Class Properties
----------------

- `$moduleConfig`: Inherited from `BaseController`, this property stores the plugin configuration passed from the main plugin file.
- `static $filters`: Holds the filter configuration for regions, countries, leave-dates, and trip-types.

Key Methods
-----------

- `__construct($moduleConfig)`: The constructor initializes the ConfigurationController and sets the module configuration. It also sets up the filters by calling the `setFilters()` method.
- `setFilters()`: Sets up and returns the filter configuration for regions, countries, leave-dates, and trip-types.
- `static getMonths()`: Generates and returns an array of months, with the key `0` set to 'all' and other keys set to the respective month names in lowercase.

Usage
-----

To utilize the filter configurations provided by the `ConfigurationController`, you can instantiate the class and access the `static $filters` property. For example:

```
$configurationController = new PureCharity\Base\ConfigurationController($moduleConfig);
$filters = $configurationController::$filters;

```

Now, you can access the individual filter configurations using their respective keys, like `region`, `country`, `leave-date`, and `trip-type`. For instance:

```
$regions = $filters['region'];
$countries = $filters['country'];
$leaveDates = $filters['leave-date'];
$tripTypes = $filters['trip-type'];

```

With this information, you can now use the filter configurations within your application to filter content according to the user's preferences.