<?php

namespace PureCharity\Base;

class PublicController extends BaseController {

    public $moduleConfig;
    private $version;
    private $pluginName;
    
    public static $classPath = '\PureCharity\Base\PublicController';

    function __construct($moduleConfig) {
        
        $this->moduleConfig = $moduleConfig;
    
        $this->pluginName = $this->moduleConfig['plugin']['name'];
        $this->version = $this->moduleConfig['plugin']['version'];
    }

	/**
	 * Register the stylesheets for the Dashboard.
	 *
	 * @since 1.0.0
	 */
	public function enqueueStyles() 
	{
        wp_enqueue_style(
            'purecharity-plugin-public', 
            $this->moduleConfig['resources']['styles'] .'public/public.css', 
            [], 
            $this->version, 
            'all'
        );
	}

	/**
	 * Register the JavaScript for the dashboard.
	 *
	 * @since 1.0.0
	 */
	public function enqueueScripts($hook) 
	{

        wp_enqueue_script(
            'purecharity-plugin-public-core', 
            $this->moduleConfig['resources']['scripts'] .'public/core.js',
            ['jquery'], 
            $this->version,
            false 
        );

        wp_localize_script('purecharity-plugin-public-core', 'pcPublicConfig', [
            'scripts' => [
                'dir' => $this->moduleConfig['resources']['scripts'] .'public/autoload/',
                'dependenciesDir' => $this->moduleConfig['resources']['scripts'] .'public/dependencies/',
                'version' => $this->version,
                'ajaxUrl' => admin_url('admin-ajax.php'),
            ],
        ]);
	}

	public static function poweredBy($hideIt = false) {
		return (
			$hideIt ?
			'' :
			'
				<div class="poweredby">
					<a href="https://purecharity.com/nonprofits/">Powered by Pure Charity</a>
				</div>
			'
		);
	}

	public static function sharingLinks($which = array(), $text = '', $title = '', $image = ''){
		$current_url = $_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];

		$facebook_url = 'https://www.facebook.com/sharer.php?p[url]='.self::currentPageUrl();

		global $PcPlugin;
		$baseModule = $PcPlugin->getModule('base', 'BaseController');
		$moduleConfig = $baseModule->getModuleConfig();

		$widgets = array();
		$widgets['facebook'] = '
			<a style="float:left;" href="'.$facebook_url.'">
				<img src="'. $moduleConfig['resources']['assets']['img'] .'facebook.png" />
			</a>
		';

		$widgets['twitter'] = '
			<a href="https://twitter.com/home?status='.$title.' '.self::currentPageUrl().'">
				<img src="'. $moduleConfig['resources']['assets']['img'] .'twitter.png" />
			</a>
		';

		if(count($which) == 0){
			return join('', $widgets);
		}else{
			$html = '';
			foreach($which as $w){
				if(isset($widgets[$w])){ $html .= $widgets[$w]; };
			}
			return $html;
		}
	}

	public static function currentPageUrl($cut_params = false) {
		$pageURL = 'http';
		if( isset($_SERVER["HTTPS"]) ) {
			if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
		}
		$pageURL .= "://";
		if ($_SERVER["SERVER_PORT"] != "80") {
			$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		} else {
			$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		}
		if($cut_params){
			return preg_split('?', $pageURL);
		}else{
			return $pageURL;
		}
	}

	public static function pcUrl(){
		$pure_base_options = get_option('purecharity_plugin_settings');
		$mode = $pure_base_options['mode'];
		
		if($mode == 'production'){
			return 'https://purecharity.com';
		}elseif('sandbox' == $mode){
			return 'https://staging.purecharity.com';
		}elseif('demo' == $mode){
			return 'https://demo.purecharity.com';
		}else{
			return $_ENV["API_URL"];
		}
	}
}