<?php

namespace PureCharity\Base;

class PaginatorController extends BaseController {
    
    public $moduleConfig;

	const DEFAULT_WRAPPER = '<div class="purecharity-paginator">';
    const DEFAULT_WRAPPER_CLOSE = '</div>';
    const DEFAULT_PER_PAGE = 10;

    function __construct($moduleConfig) {

        $this->moduleConfig = $moduleConfig;
    }

    public static function pageLinks($collection = array(), $options = array()){
        $opts = self::sanitizeOptions($options);
        if(count($collection) < $opts['per_page']){ 
            return ''; 
        }else{
            $html = $opts['wrapper_open'];

            $pages = ceil(count($collection) / $opts['per_page']);

            $html .= count($collection);
            $html .= $opts['wrapper_close'];
        }
        return $html;
    }

    public static function sanitizeOptions($options){
        $sanitized = array();
        foreach($options as $key => $value){
            if($key == '' || $value == ''){ continue; }
            $sanitized[$key] = $value;
        }
        if(!isset($sanitized['wrapper_open'])){ $sanitized['wrapper_open'] = self::DEFAULT_WRAPPER; }
        if(!isset($sanitized['wrapper_close'])){ $sanitized['wrapper_close'] = self::DEFAULT_WRAPPER_CLOSE; }
        if(!isset($sanitized['per_page'])){ $sanitized['per_page'] = self::DEFAULT_PER_PAGE; }

        return $sanitized;
    }
}