<?php

namespace PureCharity\Base;

class LoaderController extends BaseController {

    public $moduleConfig;
    private $controllers;

    protected $actions;
    protected $filters;

    function __construct($moduleConfig) {

        $this->moduleConfig = $moduleConfig;

        $this->actions = [
            'admin_menu' => [
                'AdminController' => [
                    'addAdminMenu',
                ]
            ],
            'admin_init' => [
                'AdminController' => [
                    'settingsInit',
                ],
            ],
            'plugins_loaded' => [
                'I18nController' => [
                    'loadPluginTextdomain',
                ],
            ],
            'admin_enqueue_scripts' => [
                'AdminController' => [
                    'enqueueStyles',
                    'enqueueScripts',
                ],
            ],
            'wp_enqueue_scripts' => [
                'PublicController' => [
                    'enqueueStyles',
                    'enqueueScripts',
                ],
            ],
        ];

        $this->filters = [];
    }

    public function init($controllers) {
        $this->controllers = $controllers;

        $this->initActions();
    }

    private function initActions() {

        foreach ($this->actions as $hook => $config) {
            
            if (empty($config)) { continue; }

            foreach ($config as $controller => $actions) {

                if (empty($actions)) { continue; }

                $controllerClass = (
                    !empty($this->controllers[$controller]) ?
                    $this->controllers[$controller] :
                    null
                );

                if (empty($controllerClass)) { continue; }

                foreach ($actions as $index => $method) {

                    add_action(
                        $hook,
                        [
                            $controllerClass,
                            $method
                        ]
                    );
                }
            }
        }
    }
}