<?php

namespace PureCharity\Base;

class ConfigurationController extends BaseController {
    
    public $moduleConfig;

	public static $filters;

    function __construct($moduleConfig) {

        $this->moduleConfig = $moduleConfig;

		self::$filters = $this->setFilters();
    }

	public function setFilters() {

		$filters = [
			'region' => [
                0 => 'all',
                1 => 'africa',
                2 => 'asia',
                3 => 'australia',
                4 => 'europe',
                5 => 'north-/-central-america',
                6 => 'latin-america',
                7 => 'middle-east',
            ],
            'country' => [
                'all',
                'burundi',
                'chad',
                'ethiopia',
                'ghana',
                'kenya',
                'malawi',
                'rwanda',
                'tanzania',
                'uganda',
                'zambia',
                'zimbabwe',
                'east-asia',
                'philippines',
                'germany',
                'greece',
                'ireland',
                'moldova',
                'romania',
                'russia',
                'ukraine',
                'middle-east',
                'canada',
                'costa-rica',
                'cuba',
                'dominican-republic',
                'honduras',
                'mexico',
                'nicaragua',
                'panama',
                'usa',
                'argentina',
                'bolivia',
                'colombia',
                'ecuador',
                'paraguay',
                'peru'
            ],
			'leave-date' => self::getMonths(),
            'trip-type' => [
                'all',
                'virtual',
                'medical',
                'orality'
            ],
		];

		return $filters;
	}

	public static function getMonths() {
		$months = [
		  0 => 'all',
		];
	
		for ($count = 1; $count <= 12; $count++) {
		  $months[] = strtolower(date('F', mktime(0, 0, 0, $count, 10)));
		}
	
		return $months;
	  }
}