<?php

namespace PureCharity\Base;

class AdminController extends BaseController {

    public $moduleConfig;
    private $version;
    private $pluginName;
    
    public static $classPath = '\PureCharity\Base\AdminController';

    function __construct($moduleConfig) {
        
        $this->moduleConfig = $moduleConfig;
    
        $this->pluginName = $this->moduleConfig['plugin']['name'];
        $this->version = $this->moduleConfig['plugin']['version'];
    }
	
	function addAdminMenu() { 

		add_options_page(
            'PureBase&#8482; Settings', 
            'PureBase&#8482;', 
            'manage_options', 
            'pure_plugin', 
            [$this, 'optionsPage']
        );
	}

	/**
	 * Checks for the existence of the pure base settings.
	 *
	 * @since 1.0.0
	 */
	public static function settingsExist() { 
		if (false == get_option('purecharity_plugin_settings')) { 
			add_option('purecharity_plugin_settings');
		}
	}

	/**
	 * Initializes the settings page options.
	 *
	 * @since 1.0.0
	 */
	public static function settingsInit() 
	{
		register_setting( 'pbPluginPage', 'purecharity_plugin_settings' );

		add_settings_section(
			'pure_base_pbPluginPage_section', 
			__( 'General settings', 'wordpress' ), 
			[self::$classPath, 'settingsSectionCallback'],
			'pbPluginPage'
		);

		add_settings_field( 
			'pure_base_mode', 
			__( 'API Mode', 'wordpress' ), 
            [self::$classPath, 'apiModeRender'],
			'pbPluginPage', 
			'pure_base_pbPluginPage_section' 
		);

		add_settings_field( 
			'pure_base_api_key', 
			__( 'API Key', 'wordpress' ), 
            [self::$classPath, 'apiKeyRender'],
			'pbPluginPage', 
			'pure_base_pbPluginPage_section' 
		);

		add_settings_field( 
			'pure_base_main_color', 
			__( 'Main Color', 'wordpress' ), 
            [self::$classPath, 'mainColorRender'],
			'pbPluginPage', 
			'pure_base_pbPluginPage_section' 
		);
	}

	/**
	 * Renders the select for API Mode [ staging, production ].
	 *
	 * @since 1.0.0
	 */
	public static function apiModeRender() { 

		$options = get_option( 'purecharity_plugin_settings' );
		?>
		<select name="purecharity_plugin_settings[mode]">
      <option value="sandbox" <?php @selected( $options['mode'], 'sandbox' ); ?> >Sandbox</option>
      <option value="production" <?php @selected( $options['mode'], 'production' ); ?> >Production</option>
      <option value="demo" <?php @selected( $options['mode'], 'demo' ); ?> >Demo</option>
      <option value="development" <?php @selected( $options['mode'], 'development' ); ?> >Development</option>
		</select>

	<?php

	}

	/**
	 * Renders the text field for API Key.
	 *
	 * @since 1.0.0
	 */
	public static function apiKeyRender()
	{ 
		$options = get_option( 'purecharity_plugin_settings' );
		?>
		<input type="text" name="purecharity_plugin_settings[api_key]" value="<?php echo @$options['api_key']; ?>">
		<?php
	}

	/**
	 * Renders the color picker for main color.
	 *
	 * @since 1.0.0
	 */
	public static function mainColorRender()
	{ 
		$options = get_option( 'purecharity_plugin_settings' );
		?>
		<input type="text" id="main_color" name="purecharity_plugin_settings[main_color]" value="<?php echo @$options['main_color']; ?>">
		<?php
	}

	/**
	 * Callback for use with Settings API.
	 *
	 * @since 1.0.0
	 */
	public static function settingsSectionCallback() 
	{ 
		echo __( 'General settings for the Base module. Used across the other modules.', 'wordpress' );
	}

	
	/**
	 * Creates the options page.
	 *
	 * @since 1.0.0
	 */
	public static function optionsPage()
	{
    ?>
    <div class="wrap">
      <form action="options.php" method="post" class="pure-settings-form">
				<?php
					echo '<img align="left" src="' . plugins_url( 'purecharity-plugin/resources/assets/img/purecharity.png' ) . '" > ';
				?>
				<h2 style="padding-left:100px;padding-top: 20px;padding-bottom: 50px;border-bottom: 1px solid #ccc;">PureBase&#8482; Settings</h2>
				
				<?php
				settings_fields( 'pbPluginPage' );
				do_settings_sections( 'pbPluginPage' );
				submit_button();
				?>
				
			</form>
    </div>
    <?php
	}

	/**
	 * Register the stylesheets for the Dashboard.
	 *
	 * @since 1.0.0
	 */
	public function enqueueStyles() 
	{
        wp_enqueue_style(
            'purecharity-plugin-admin', 
            $this->moduleConfig['resources']['styles'] .'admin/admin.css', 
            [], 
            $this->version, 
            'all'
        );
	}

	/**
	 * Register the JavaScript for the dashboard.
	 *
	 * @since 1.0.0
	 */
	public function enqueueScripts($hook) 
	{

        wp_enqueue_script(
            'purecharity-plugin-admin-core', 
            $this->moduleConfig['resources']['scripts'] .'admin/core.js',
            ['jquery'], 
            $this->version,
            false 
        );

        wp_localize_script('purecharity-plugin-admin-core', 'pcPublicConfig', [
            'scripts' => [
                'dir' => $this->moduleConfig['resources']['scripts'] .'admin/autoload/',
                'dependenciesDir' => $this->moduleConfig['resources']['scripts'] .'admin/dependencies/',
                'version' => $this->version,
                'ajaxUrl' => admin_url('admin-ajax.php'),
            ],
        ]);

        wp_enqueue_script(
            'admin-color-picker', 
            $this->moduleConfig['resources']['scripts'] .'admin/spectrum.js'
        );
	}
}