BaseController.php
===================
The `BaseController.php` module provides the foundational functionality for the Pure Charity plugin. This base module is responsible for loading, managing, and initializing other controller classes within the plugin. By extending the `PcPlugin` class, it inherits core functionalities, which can be utilized by other modules in the plugin.

Class Properties
----------------

- `$config`: Contains the configuration information for the base module, such as namespace, controllers, and autoload settings.
- `$controllers`: Stores the instances of the loaded controller classes.
- `$path`: Holds the file path of the base module.
- `$moduleConfig`: Inherited from `PcPlugin`, this property stores the plugin configuration passed from the main plugin file.

Key Methods
-----------

- `__construct($moduleConfig)`: The constructor initializes the base module, sets the module configuration, autoloads the required controllers, and triggers the loader initialization.
- `autoload()`: Scans the `controllers` directory within the base module and loads the specified controller classes based on the autoload configuration. Each controller instance is stored in the `$controllers` property.
- `getController($controllerName)`: Retrieves a controller instance by its name. Returns `null` if the controller is not found.
- `purecharityPluginTemplate()`: Returns the path to the `purecharity-plugin-template.php` file, which is the default template for the plugin's public view.
- `purecharityGetTemplates()`: Retrieves the available page templates and appends the default plugin template to the list.

Extending the BaseController
----------------------------

To add new controllers to the base module, follow these steps:

1. Create a new controller class file inside the `/modules/base/controllers/` directory. The class should extend the `PureCharity\Base\BaseController` class to inherit the base functionality.
2. Add the new controller class name to the `$config['controllers']['autoload']` array in the `BaseController` class. This ensures that the new controller is automatically loaded and initialized by the `autoload()` method.

By following these steps, the new controller will be available for use within the Pure Charity plugin, and can be accessed using the `getController()` method.

Summary
-------

The `BaseController.php` module is the foundation of the Pure Charity plugin, providing the essential functionalities for managing and loading other controller classes. By extending the `PcPlugin` class, it benefits from the core functionalities provided by the main plugin file. The base module autoloads the required controllers and provides methods for accessing and managing them. To extend the base module with additional controllers, you can follow the steps outlined above.