<?php 
  $dirname = dirname(__FILE__);
  include($dirname .'/single-view-vars.php');

  $fundingGoal = (
    self::$fundraiser->funding_goal !== 'anonymous' ?
    self::$fundraiser->funding_goal :
    self::$fundraiser->funding_total
  );

  $fundingNeeded = (
    self::$fundraiser->funding_needed !== 'anonymous' ?
    self::$fundraiser->funding_needed :
    self::$fundraiser->funding_total
  );

  $funded = self::percent(
    $fundingGoal - $fundingNeeded,
    $fundingGoal
  );

  $html = '
    <div class="fr-body '. $tabs_span_class .' pure_col">
      <div id="fr-tabs" class="pure_col pure_span_24">
         <ul class="fr-tabs-list pure_col pure_span_24">
           <li><a class="fr-themed-link" href="#tab-1">About</a></li>
           '. (isset($options['updates_tab']) ?  '' : '<li><a class="fr-themed-link" href="#tab-2">Updates</a></li>') .'
           '. (isset($options['backers_tab']) ?  '' : '<li><a class="fr-themed-link" href="#tab-3">Backers</a></li>') .'
         </ul>
         <div id="tab-1" class="tab-div pure_col pure_span_24">'.self::$fundraiser->about.'</div>
         <div id="tab-2" class="tab-div pure_col pure_span_24">
            '. self::printUpdates() .'
         </div>
         <div id="tab-3" class="tab-div pure_col pure_span_24"><!-- we will need to be able check a box to hide this tab / info in the admin of the plugin -->
            '. self::printBackers() .'
         </div>
       </div>
    </div>
  ';
  if($has_none || $has_both){

    $title = self::$fundraiser->name;
    if(isset($options['title']) && $options['title'] == 'owner_name'){
      $title = self::$fundraiser->owner->name;
    }
    if(isset($options['title']) && $options['title'] == 'title_and_owner_name'){
      $title = self::$fundraiser->name.' by '.self::$fundraiser->owner->name;
    }

    global $PcPlugin;
		$baseModule = $PcPlugin->getModule('base', 'BaseController');
		$basePublicController = $baseModule->getController('PublicController');

    $fundraisersModule = $PcPlugin->getModule('fundraisers', 'FundraisersController');
    $moduleConfig = $fundraisersModule->getModuleConfig();

    $html .= '
    <div class="fr-body pure_span_4 pure_col text-centered">
      <strong>'.$date_diff.'</strong><br/> <span class="fr-stat-title">Days to Go</span><br /><br />
        '.$basePublicController::sharingLinks(array(), self::$fundraiser->about, $title, self::$fundraiser->images->large).'
        <a target="_blank" href="'.$basePublicController::pcUrl().'/'.self::$fundraiser->slug.'">
          <img src="'. $moduleConfig['resources']['assets']['img'] .'/share-purecharity.png">
        </a>
      </div>
    ';
  }