<?php
  $dirname = dirname(__FILE__);
  include($dirname .'/single-view-vars.php');

  $html = '';
  if($has_one_time || $has_recurring){
    $html .= '
      <div class="fr-single-info pure_col pure_span_24">
        <ul class="fr-single-stats pure_col pure_span_24">';
    if($has_one_time){
      $html .=' <li class="pure_col ' . $div_span_class . '"><strong>$'.number_format(self::$fundraiser->funding_goal, 0, '.', ',').'</strong><br/> <span class="fr-stat-title">One-time Goal</span></li>
                <li class="pure_col ' . $div_span_class . '"><strong>$'.number_format(self::$fundraiser->funding_needed, 0, '.', ',').'</strong><br/> <span class="fr-stat-title">One-time Still Needed</span></li>'; 
    }
    if($has_recurring){
      $html .=' <li class="pure_col ' . $div_span_class . '"><strong>$'.number_format(self::$fundraiser->recurring_funding_goal, 0, '.', ',').'</strong><br/> <span class="fr-stat-title">Recurring Goal</span></li>
                <li class="pure_col ' . $div_span_class . '"><strong>$'.number_format(self::$fundraiser->recurring_funding_needed, 0, '.', ',').'</strong><br/> <span class="fr-stat-title">Recurring Still Needed</span></li>';  
    }
    
    global $PcPlugin;
		$baseModule = $PcPlugin->getModule('base', 'BaseController');
		$basePublicController = $baseModule->getController('PublicController');

    $fundraisersModule = $PcPlugin->getModule('fundraisers', 'FundraisersController');
    $moduleConfig = $fundraisersModule->getModuleConfig();

    $options = get_option( 'purecharity_plugin_fundraisers_settings' );

    if(!$has_both){

      $daysToGoMarkup = '';
      if (
        !isset($options['days_to_go']) &&
        !$isUnlimited
      ) {
        $daysToGoMarkup = '<li class="pure_col pure_span_9"><strong>'.$date_diff.'</strong><br/> <span class="fr-stat-title">Days to Go</span></li>';
      }

      $html .= (
        $daysToGoMarkup .
        '<li class="pure_col pure_span_4 sharing_links">
          '.$basePublicController::sharingLinks(array(), self::$fundraiser->name." Fundraisers").'
          <a target="_blank" href="'.$basePublicController::pcUrl().'/'.self::$fundraiser->slug.'">
          <img src="'. $moduleConfig['resources']['assets']['img'] .'/share-purecharity.png">
            </a>
        </li>'
      ); 
    }

    $html .='
        </ul>
      </div>
    ';
  }