window.addEventListener('load', (event) => {

    window.andromedaAutoloadDependencies = [];

    window.breakpoints = {
        sm: 576,
        md: 768,
        lg: 992,
    };
    
    window.autoload = [
        {
            script: 'base',
            className: 'PcPublicBase',
            onload: () => {
                window.PcPublicBase.init();
            },
            loadWhen: () => {
                return false;
            }
        },
        {
            script: 'sponsorships',
            className: 'PcSponsorships',
            onload: () => {
                window.PcSponsorships.init();
            },
            loadWhen: () => {

                return (
                    (
                        typeof document.querySelector('.js-sponshorships-lazy-loaded') !== 'undefined' &&
                        document.querySelector('.js-sponshorships-lazy-loaded')
                    ) ||
                    (
                        typeof document.querySelector('.pc-single-view') !== 'undefined' &&
                        document.querySelector('.pc-single-view')
                    )
                );
            }
        },
        {
            script: 'trips',
            className: 'PcTrips',
            onload: () => {
                window.PcTrips.init();
            },
            loadWhen: () => {

                return (
                    typeof document.querySelector('.pc-trips-trigger') !== 'undefined' &&
                    document.querySelector('.pc-trips-trigger')
                );
            }
        },
        {
            script: 'fundraisers',
            className: 'PcFundraisers',
            onload: () => {
                window.PcFundraisers.init();
            },
            loadWhen: () => {

                return (
                    typeof document.querySelector('#pc-fr-page-container-flag') !== 'undefined' &&
                    document.querySelector('#pc-fr-page-container-flag')
                );
            }
        },
    ];

    window.scriptsDir = pcPublicConfig.scripts.dir;

    autoload.forEach((element) => {
        
        if (
            typeof element.loadWhen === 'function' &&
            element.loadWhen() 
        ) { 
            if (
                typeof element.worksWith !== 'undefined' &&
                element.worksWith !== null &&
                element.worksWith.length > 0
            ) {

                window.andromedaAutoloadDependencies.push({
                    element: element,
                    loaded: 0,
                });

                element.worksWith.forEach((dependency) => {
                    window.loadDependencyScript(dependency.script, (window.andromedaAutoloadDependencies.length - 1));
                });
            } else { 
                window.loadScript(element);
            }
        }
    });
});

window.loadScript = (element) => {
    const script = document.createElement('script');
    script.src = `${pcPublicConfig.scripts.dir}${element.script}.js?ver=${pcPublicConfig.scripts.version}`;
    script.async = 'async';
    script.onload = () => {
        if (typeof window[element.className] === 'object') {
            if (typeof element.onload !== 'undefined') {
                element.onload();
            }
        }
    };

    // Append the Script
    document.body.appendChild(script);
}

window.loadDependencyScript = (dependency, id) => {
    const script = document.createElement('script');
    script.src = `${pcPublicConfig.scripts.dependenciesDir}${dependency}.js?ver=${pcPublicConfig.scripts.version}`;
    script.async = 'async';
    script.onload = () => {
        window.andromedaAutoloadDependencies[id].loaded += 1;
        if (window.andromedaAutoloadDependencies[id].loaded >= window.andromedaAutoloadDependencies[id].element.worksWith.length) {
            window.loadScript(window.andromedaAutoloadDependencies[id].element);
        }
    };

    // Append the Script
    document.body.appendChild(script);
}