trips.js
========

`trips.js` is a JavaScript module responsible for managing the UX handlers of the Trips functionality.

Class: PcTrips
--------------

The `PcTrips` class contains methods for initializing event handlers, interacting with filter options, and managing the submission of filters.

### Methods

- `init()`: Initializes the module by setting up properties and calling `initEventHandlers()` to set up event handlers.
- `prepareSelectorClass(selectorPureClass)`: Prepares the selector classes by converting a given object with keys and pure class names into a new object with the same keys and class names prefixed with a dot (`.`).
- `initEventHandlers()`: Sets up event handlers for various UI interactions, such as filter button clicks, filter submissions, live search filter submissions, filter resets, page button clicks, and filter option changes.
- `setFilterOptionChangeState(state = false)`: Sets the state of a filter option change to the given boolean value (`true` or `false`).
- `getFilterOptionChangeState()`: Returns the current state of a filter option change.
- `handleFilterOptionChanged(event)`: Handles filter option changes by updating the filter option change state.
- `handlePageButton(event)`: Handles page button clicks by updating the `_page` query parameter and triggering a filter submission.
- `handleResetFilters(event)`: Handles filter resets by navigating to the current page without any query parameters.
- `handleSubmitLiveSearchFilters(event)`: Handles live search filter submissions by setting the filter option change state to `true` and triggering a filter submission.
- `handleFilterButtonClick(event)`: Handles filter button clicks by toggling the visibility of filter options.
- `handleSubmitFilters(event)`: Handles filter submissions by performing an AJAX request to filter and update the Trips listing.
- `prepareFilters(selectors = [])`: Prepares an object containing filter key-value pairs based on the given selectors array (or `defaultFilterSelectors` if no array is provided).
- `fetchShortcodeInitialQuery()`: Fetches the initial query for the Trips shortcode, removing any unnecessary query parameters.
- `handleSubmitState(target, lock = true)`: Locks or unlocks the submit button by disabling or enabling the given target element based on the `lock` parameter.

### Usage

1. Include the `trips.js` file in your project.
2. Make sure `core.js` (or a similar autoloader) is included and properly configured to load `trips.js` when necessary.
3. The `PcTrips` class will automatically be instantiated and assigned to the global `window.PcTrips` object, so you can access its methods and properties using `window.PcTrips`.