TripsController
===============

The `TripsController.php` is the main controller for the `Trips` module. It extends the `PcPlugin` class and is responsible for initializing, managing, and providing access to other controllers within the module.

Class Properties
----------------

- `$config`: An array that holds the configuration settings for the `TripsController`.
- `$controllers`: An array that stores instances of the different controllers within the module.
- `$path`: The directory path to the current file.
- `$moduleConfig`: The module configuration object.
- `$disableLiveSearch`: A static boolean property that disables live search functionality when set to `true`.

Constructor
-----------

- `__construct($moduleConfig)`: The constructor initializes the `TripsController` with the given module configuration, sets up the base template page and base config, and autoloads the WordPress controllers.

Methods
-------

- `autoload()`: This private method autoloads the WordPress controllers by iterating through the `$config['controllers']['autoload']` array and initializing each controller.
- `getController($controllerName)`: This method returns the instance of the controller specified by `$controllerName`.
- `purecharityPluginTemplate()`: This method returns the path to the default Pure Charity plugin template.
- `purecharityGetTemplates()`: This method retrieves the list of available page templates and appends the default Pure Charity plugin template to the list.

Usage
-----

To utilize the `TripsController`, create a new instance of the class and pass the module configuration object to the constructor:

```
$moduleConfig = ...; // Module configuration
$tripsController = new PureCharity\Trips\TripsController($moduleConfig);

```

With the `TripsController` instance, you can now access and interact with the various controllers within the module, such as the `AdminController`, `ShortcodeController`, and `PublicController`. For example, to get the instance of the `AdminController`, you can use the `getController()` method:

```
$adminController = $tripsController->getController('AdminController');

```

This allows you to utilize the `TripsController` to manage and organize the controllers within the Trips module.