<?php

namespace PureCharity\Sponsorships;

class LoaderController extends SponsorshipsController {

    public $moduleConfig;
    private $controllers;

    protected $extendedHooks;
    protected $actions;
    protected $filters;

    function __construct($moduleConfig) {

        $this->moduleConfig = $moduleConfig;

        $this->extendedHooks = [
            'wp_ajax',
            'wp_ajax_nopriv',
        ];

        $this->actions = [
            'admin_menu' => [
                'AdminController' => [
                    'addAdminMenu',
                ]
            ],
            'admin_init' => [
                'AdminController' => [
                    'settingsInit',
                    'sponsorshipsCacheReset',
                ],
            ],
            'plugins_loaded' => [
                'I18nController' => [
                    'loadPluginTextdomain',
                ],
            ],
            'admin_enqueue_scripts' => [
                'AdminController' => [
                    'enqueueStyles',
                    'enqueueScripts',
                ],
            ],
            'wp_enqueue_scripts' => [],
            'get_footer' => [
                'PublicController' => [
                    'enqueueScripts',
                    'enqueueStyles',
                ],
            ],
            'parse_request' => [
                'PublicController' => [
                    'sniffRequests',
                ],
            ],
            'template_redirect' => [
                'PublicController' => [
                    'sniffRequests',
                ],
            ],
            'wp_ajax' => [
                'PublicController' => [
                    'sponsorshipsLazyLoading',
                ],
                'AdminController' => [
                    'generateSponsorshipsCustomFieldsExample',
                ],
            ],
            'wp_ajax_nopriv' => [
                'PublicController' => [
                    'sponsorshipsLazyLoading',
                ],
                'AdminController' => [
                    'generateSponsorshipsCustomFieldsExample',
                ],
            ],
        ];

        $this->filters = [
            'query_vars' => [
                'PublicController' => [
                    //'ssForceTemplate',
                ],
            ],
        ];
    }

    public function init($controllers) {
        $this->controllers = $controllers;

        $this->initHooks($this->actions, false);
        $this->initHooks($this->filters, true);
    }

    private function initHooks($hooks, $isFilters = false) {

        foreach ($hooks as $hook => $config) {
            
            if (empty($config)) { continue; }

            foreach ($config as $controller => $actions) {

                if (empty($actions)) { continue; }

                $controllerClass = (
                    !empty($this->controllers[$controller]) ?
                    $this->controllers[$controller] :
                    null
                );

                if (empty($controllerClass)) { continue; }

                foreach ($actions as $index => $method) {
                    
                    $hookWorkable = $hook;

                    if (in_array($hook, $this->extendedHooks)) {

                        $hookWorkable .= '_'. $method;
                    }

                    if (!$isFilters) {
                        add_action(
                            $hookWorkable,
                            [
                                $controllerClass,
                                $method
                            ]
                        );
                    } else {
                        add_filter(
                            $hookWorkable,
                            [
                                $controllerClass,
                                $method
                            ]
                        );
                    }
                }
            }
        }
    }
}