<?php

namespace PureCharity\Sponsorships;

class SponsorshipsController extends \PureCharity\PcPlugin {

    private $config;
    private $controllers;
    private $path;
    
    public $moduleConfig;

    function __construct($moduleConfig) {

        // Set Module Config
        $this->moduleConfig = $moduleConfig;

        // Set Base Template Page
        $this->path = dirname(__FILE__);

        // Set Base Config
        $this->config = [
            'namespace' => (
                $this->moduleConfig['mainNamespace'] .'\\'.
                'Sponsorships'
            ),
            'controllers' => [
                'path' => $this->path .'/controllers/',
                'restricted' => [
                    '.',
                    '..',
                    'index',
                ],
                'autoload' => [
                    'PaginatorController',
                    'I18nController',
                    'AdminController',
                    'ShortcodeController',
                    'PublicController',
                    'LoaderController',
                ],
            ],
        ];

        // Define Controllers Container
        $this->controllers = [];

        // Autoload WP Controllers
        $this->autoload();

        // Trigger Loader Initialization
        $loaderController = $this->getController('LoaderController');
        
        if (!empty($loaderController)) {
            $loaderController->init($this->controllers);
        }
    }

    private function autoload() {
        if (
            empty($this->config['controllers']) ||
            empty($this->config['controllers']['path'])
        ) { return false; }

        $controllersDir = scandir($this->config['controllers']['path']);

        if (
            empty($controllersDir) ||
            count($controllersDir) <= 2
        ) { return false; }
        
        foreach ($this->config['controllers']['autoload'] as $controllerClassName) {

            $controllerScript = (
                $controllerClassName .'.php'
            );

            if (in_array($controllerClassName, $this->config['controllers']['restricted'])) { continue; }

            $controllerPath = $this->config['controllers']['path'] . $controllerScript;

            if (
                !file_exists($controllerPath) ||
                !empty($this->controllers[$controllerClassName])
            ) { continue; }

            require_once $controllerPath;

            $controllerClass = (
                $this->config['namespace'] .'\\'.
                $controllerClassName
            );

            $this->controllers[$controllerClassName] = new $controllerClass($this->moduleConfig);
        }
    }

    public function getController($controllerName) {
        $moduleInstance = $this->getModule('sponsorships', 'SponsorshipsController');

        if (
            empty($moduleInstance) && 
            !empty($this)
        ) {
            $moduleInstance = $this;
        }

        return (
            !empty($moduleInstance->controllers[$controllerName]) ?
            $moduleInstance->controllers[$controllerName] :
            null
        );
    }

    public function purecharityPluginTemplate() {
        $moduleConfig = $this->getModuleConfig();
        return $moduleConfig['templates']['public'] .'purecharity-plugin-template.php';
    }

    public function purecharityGetTemplates() {
        $templates = get_page_templates();
        $templates['[Plugin Template] Default single view'] = 'purecharity-plugin-template.php';
        return $templates;
    }
}