FundraisersController
=====================

The `FundraisersController.php` is the main controller for the `Fundraisers` module. It extends the `PcPlugin` class and is responsible for initializing, managing, and providing access to other controllers within the module.

Class Properties
----------------

- `$config`: An array that holds the configuration settings for the `FundraisersController`.
- `$controllers`: An array that stores instances of the different controllers within the module.
- `$path`: The directory path to the current file.
- `$moduleConfig`: The module configuration object.

Constructor
-----------

- `__construct($moduleConfig)`: The constructor initializes the `FundraisersController` with the given module configuration, sets up the base template page and base config, and autoloads the WordPress controllers.

Methods
-------

- `autoload()`: This private method autoloads the WordPress controllers by iterating through the `$config['controllers']['autoload']` array and initializing each controller.
- `getController($controllerName)`: This method returns the instance of the controller specified by `$controllerName`.
- `purecharityPluginTemplate()`: This method returns the path to the default Pure Charity plugin template.
- `purecharityGetTemplates()`: This method retrieves the list of available page templates and appends the default Pure Charity plugin template to the list.

Usage
-----

To utilize the `FundraisersController`, create a new instance of the class and pass the module configuration object to the constructor:

```
$moduleConfig = ...; // Module configuration
$fundraisersController = new PureCharity\Fundraisers\FundraisersController($moduleConfig);

```

With the `FundraisersController` instance, you can now access and interact with the various controllers within the module, such as the `AdminController`, `ShortcodeController`, and `PublicController`. For example, to get the instance of the `AdminController`, you can use the `getController()` method:

```
$adminController = $fundraisersController->getController('AdminController');

```

This allows you to utilize the `FundraisersController` to manage and organize the controllers within the Fundraisers module.