Sponsorships Endpoint
=====================

The `Sponsorships.php` is an endpoint within the `ApiController.php` of the `BaseController.php` module. It is responsible for handling the `/sponsorships` API endpoint in the Pure Charity plugin.

Class Properties
----------------

- `static $rest`: The RESTful route segment for the sponsorships endpoint.

Constructor
-----------

- `__construct()`: The constructor initializes the `Sponsorships` endpoint by setting the `$rest` property.

Usage
-----

To utilize the `Sponsorships` endpoint in conjunction with the `ApiController`, you can call the `apiCall()` method on an instance of the `ApiController` class with the required parameters. For example:

```
$apiController = new PureCharity\Base\ApiController($moduleConfig);
$response = $apiController->apiCall('sponsorships', $urlParams, $queryParams);

```

Here, `$urlParams` is an array of URL parameters, and `$queryParams` is an array of query parameters. The method returns a JSON-decoded API response or `null` if the call fails.

With this information, you can now use the `Sponsorships` endpoint to fetch sponsorship data from the API and utilize it within your application as needed.