LoaderController
================

The `LoaderController.php` is a controller within the `BaseController.php` module. It is responsible for initializing and managing WordPress hooks and filters for the Pure Charity plugin.

Class Properties
----------------

- `$moduleConfig`: The module configuration object.
- `$controllers`: An array of controller instances.
- `$actions`: An associative array that maps WordPress action hooks to controller methods.
- `$filters`: An array of WordPress filters.

Constructor
-----------

- `__construct($moduleConfig)`: The constructor initializes the `LoaderController` with the given module configuration and sets up the default actions.

Methods
-------

- `init($controllers)`: This method accepts an array of controller instances and initializes the actions for the given controllers.
- `initActions()`: This private method initializes the actions by iterating through the `$actions` property and registering each action using the `add_action()` WordPress function.

Usage
-----

To utilize the `LoaderController` in conjunction with the `BaseController`, you can call the `init()` method on an instance of the `LoaderController` class. For example:

```
$baseController = new PureCharity\Base\BaseController($moduleConfig);
$loaderController = $baseController->getController('LoaderController');
$loaderController->init($controllers);

```

Here, `$controllers` is an array of controller instances, and the `init()` method initializes the WordPress hooks and filters for the given controllers.

With this information, you can now use the `LoaderController` to manage and organize WordPress hooks and filters within your application.