ApiController
=============

The `ApiController.php` is a controller within the `BaseController.php` module, responsible for managing API calls and handling API endpoints for the Pure Charity plugin.

Class Properties
----------------

- `$moduleConfig`: Inherited from `BaseController`, this property stores the plugin configuration passed from the main plugin file.
- `$endpoints`: Holds the loaded API endpoint configurations.
- `static $apiUrl`: Stores the base URL for API calls.
- `static $apiKey`: Stores the API key required for authentication.
- `$config`: Configuration settings for the controller, including namespace and endpoints.
- `$path`: The file path of the controller.

Key Methods
-----------

- `__construct($moduleConfig)`: The constructor initializes the ApiController, sets the module configuration, path, and config. It autoloads the API endpoints and initializes the API settings.
- `autoloadEndpoints()`: Autoloads the API endpoints available in the `endpoints` directory.
- `initApi()`: Initializes the API settings by fetching the plugin options and setting the appropriate API base URL and API key.
- `apiCall($endpoint, $urlParams, $queryParams)`: Executes an API call to the specified endpoint with the given URL parameters and query parameters. Returns the JSON-decoded API response or `null` if the call fails.

Usage
-----

To utilize the `ApiController` for making API calls, you can instantiate the class and call the `apiCall()` method with the required parameters. For example:

```
$apiController = new PureCharity\Base\ApiController($moduleConfig);
$response = $apiController->apiCall($endpoint, $urlParams, $queryParams);

```

Here, `$endpoint` is the name of the endpoint, `$urlParams` is an array of URL parameters, and `$queryParams` is an array of query parameters. The method returns a JSON-decoded API response or `null` if the call fails.

With this information, you can now use the `ApiController` to fetch data from the API and utilize it within your application as needed.