# purecharity-plugin

Combines the functionality of
Pure-base - Done;
Pure-fundraisers - Done;
Pure-Sponsorships - Done;
Pure-Trips - Done;
Pure-GivingCircles - Disabled;

into one maintainable plugin. 

Pure Charity Plugin
===================

This documentation provides an overview of the `purecharity-plugin.php` file, which is the main file for the Pure Charity plugin. The plugin is responsible for managing Pure Charity products and features.

Overview
--------

The `PureCharity\PcPlugin` class is the main class for the plugin. It handles autoloading, module loading, and various utility functions.

### Configurations

The `$config` property is an associative array that holds the plugin's configuration information, such as plugin name, version, base paths, autoloading settings, and resources.

The `$moduleConfig` property is an associative array that holds the module configuration information, including resource version, base paths, main namespace, plugin, resources, and templates.

The `$modules` property is an associative array that holds the loaded module instances.

### Constructor

The constructor initializes the configuration arrays and calls the `autoload()` method to load the modules specified in the autoloading configuration.

### Autoload

The `autoload()` method scans the module directory specified in the autoloading configuration and loads the specified module controllers. It creates instances of the module controllers and stores them in the `$modules` property.

### Utility Functions

The following utility functions are included in the class:

- `getModule($module, $controller)`: Returns the specified module and controller instance.
- `dd($data, $shouldDie = true)`: Dumps and dies the given data, useful for debugging purposes.
- `pluralize($count, $singular, $plural = false)`: Pluralizes the given word based on the count.
- `psTruncate($text, $chars = 25)`: Truncates the given text to the specified number of characters.
- `getModuleConfig()`: Returns the module configuration array.
- `getCoreInstance()`: Returns the core plugin instance.
- `returnAjaxResponse($success, $data)`: Returns a JSON-encoded AJAX response.
- `handleModuleResource($moduleName, $add = true)`: Handles module resource existence in the global scope.
- `moduleResourceExists($moduleName)`: Checks if the module resource exists in the global scope.
- `truncate($text, $chars)`: Truncates the given text to the specified number of characters (alias of `psTruncate`).

### Alias Function

- `truncate($text, $chars = 25)`: Alias for `psTruncate()`.

Initialization
--------------

At the end of the file, an instance of the `PureCharity\PcPlugin` class is created and stored in the `$PcPlugin` variable. Additionally, an alias for the `psTruncate()` function is created if it does not exist already.

The `purecharity-plugin.php` file is the main entry point for the Pure Charity plugin. As we continue, it's essential to understand that this file is responsible for initializing and managing the core functionalities provided by the plugin. The plugin is modular, which means it can load different features (modules) based on the specified configuration.

Plugin Modules
--------------

The plugin is designed to be modular, allowing it to load and manage different features as needed. The module configuration is defined in the `$config['autoload']['modules']` property, and the following modules are currently available:

1. `base`: BaseController
2. `fundraisers`: FundraisersController
3. `sponsorships`: SponsorshipsController
4. `trips`: TripsController
5. `giving-circles`: GivingCirclesController (currently commented out)

Each module consists of a unique namespace (folder) and a primary controller class, which handles the module's functionality. The `autoload()` method in the `PcPlugin` class loads and initializes these modules.

To understand the specific functionalities of these modules, you will need to examine the individual module files (controllers) inside their respective folders.

Extending the Plugin
--------------------

To extend the plugin with additional modules, follow these steps:

1. Create a new folder (namespace) inside the `/modules` directory with a suitable name for the module.
2. Create a new controller class file inside the newly created folder. The class should extend the `PureCharity\BaseController` class to inherit the base functionality.
3. Add the module to the `$config['autoload']['modules']` property in the `PcPlugin` class, using the folder name as the key and the controller class name as the value.

By following these steps, the new module will be automatically loaded and initialized by the `autoload()` method in the `PcPlugin` class.

Summary
-------

The `purecharity-plugin.php` file is the starting point for the Pure Charity plugin. It initializes and manages the core functionalities provided by the plugin, including loading and managing modular features. The plugin currently provides several modules, each with its own namespace and controller. By extending the plugin with additional modules, you can easily add new features and functionality to the Pure Charity plugin.

### Prepros License Key: `4PCUF-2DMJZ-RBTGC-C6NG7-N4YE3-3CWJS`