## Changelog

### Version 3.0.0

## purecharity-plugin.php

#### Added
- Introduced a new `$config` array that holds various configuration settings for the plugin.
- Added a `coreActivate` method to deactivate the legacy plugin upon activation of the new one.
- Implemented an `autoload` method for dynamically loading modules.
- Introduced a `getModule` method to retrieve specific modules.
- Added utility methods like `dd`, `pluralize`, `psTruncate`, `getModuleConfig`, `getCoreInstance`, `returnAjaxResponse`, `handleModuleResource`, `moduleResourceExists`, and `truncate`.
- Added alias function `truncate` for `psTruncate`.

#### Changed
- Refactored the class structure and moved to a namespace `PureCharity`.
- Updated the plugin version to 3.0.0 in the `$version` variable.

#### Removed
- Commented out the 'giving-circles' module from the autoload configuration.

## `/modules/base/BaseController.php`

### Added
- Introduced a new `BaseController` class that extends the `PcPlugin` class.
- The `BaseController` class has a private `$config` variable to hold the configuration settings, a private `$controllers` variable to hold the controllers, and a private `$path` variable to hold the base template page path.
- The `BaseController` class has a public `$moduleConfig` variable to hold the module configuration.
- The `BaseController` class has a constructor function that sets the module configuration, base template page, base configuration, and autoloads the WP controllers.
- The `BaseController` class has a private `autoload` function that loads the necessary controllers.
- The `BaseController` class has a public `getController` function that retrieves a specific controller.
- The `BaseController` class has a public `purecharityPluginTemplate` function that retrieves the plugin template.
- The `BaseController` class has a public `purecharityGetTemplates` function that retrieves the page templates.

### Changed
- No changes were made in this version.

### Removed
- No features were removed in this version.

## `/modules/base/controllers/AdminController.php`

### Added
- Introduced the class `AdminController` that extends `BaseController`.
- Added `$moduleConfig`, `$version`, and `$pluginName` as properties.
- Implemented the `__construct` method for initial setup.
- Added `addAdminMenu()` method for adding options page to WP Admin.
- Introduced `settingsExist()`, `settingsInit()` utility methods for managing plugin settings.
- Included rendering methods `apiModeRender()`, `apiKeyRender()`, and `mainColorRender()` for settings UI.
- Added `settingsSectionCallback()` for displaying general settings info.
- Implemented `optionsPage()` for creating the settings page UI.
- Added `enqueueStyles()` and `enqueueScripts()` for loading admin assets.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/ApiController.php`

### Added
- Introduced `ApiController` class that extends `BaseController`.
- Added public variables `$moduleConfig` and `$endpoints`.
- Added static variables `$apiUrl` and `$apiKey`.
- Added private variables `$config` and `$path`.
- Implemented `__construct` method for class initialization.
- Implemented `autoloadEndpoints` method for dynamically loading endpoint modules.
- Introduced `initApi` method to initialize the API settings.
- Implemented `apiCall` method for making an API call.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/ConfigurationController.php`

### Added
- Introduced `ConfigurationController` class that extends `BaseController`.
- Added public variable `$moduleConfig`.
- Added static variable `$filters`.
- Implemented `__construct` method for class initialization.
- Implemented `setFilters` method for defining filter options like region, country, leave-date, and trip-type.
- Introduced `getMonths` static method for generating an array of months.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/I18nController.php`

### Added
- Introduced `I18nController` class that extends `BaseController`.
- Added public variable `$moduleConfig`.
- Added private variable `$domain`.
- Implemented `__construct` method for class initialization.
- Added `loadPluginTextdomain` method for loading plugin text domain for translation.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/LoaderController.php`

### Added
- Introduced the class `LoaderController` that extends `BaseController`.
- Added public variable `$moduleConfig`.
- Added private variable `$controllers`.
- Added protected arrays `$actions` and `$filters` to store hooks and filters.
- Implemented `__construct` method for initial setup.
- Implemented `init` method to initiate actions and controllers.
- Introduced `initActions` method to add actions based on controller and method references.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/PaginatorController.php`

### Added
- Introduced the class `PaginatorController` that extends `BaseController`.
- Added public variable `$moduleConfig`.
- Added constant variables `DEFAULT_WRAPPER`, `DEFAULT_WRAPPER_CLOSE`, and `DEFAULT_PER_PAGE`.
- Implemented `__construct` method for initial setup.
- Added `pageLinks` method for generating pagination links.
- Introduced `sanitizeOptions` method for sanitizing options provided to the paginator.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/PublicController.php`

### Added
- Introduced the class `PublicController` that extends `BaseController`.
- Added public variables `$moduleConfig`, `version`, and `pluginName`.
- Introduced static variable `$classPath`.
- Implemented `__construct` method to initialize properties.
- Added `enqueueStyles` and `enqueueScripts` methods for frontend resources.
- Implemented `poweredBy` method for footer attribution.
- Created `sharingLinks` method for generating social share links.
- Introduced `currentPageUrl` method to get the current URL.
- Created `pcUrl` method to determine the appropriate Pure Charity URL based on the mode.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/endpoints/Events.php`

### Added
- Introduced the class `Events`.
- Added a static variable `$rest`.
- Implemented `__construct` method to initialize the `$rest` variable with the value 'events'.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/endpoints/ExternalFundraisers.php`

### Added
- Introduced the class `ExternalFundraisers`.
- Added a static variable `$rest`.
- Implemented `__construct` method to initialize the `$rest` variable with the value 'external_fundraisers'.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/endpoints/Fundraisers.php`

### Added
- Introduced the class `Fundraisers`.
- Added a static variable `$rest`.
- Implemented `__construct` method to initialize the `$rest` variable with the value 'fundraisers'.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/endpoints/GivingCircles.php`

### Added
- Introduced the class `GivingCircles`.
- Added a static variable `$rest`.
- Implemented `__construct` method to initialize the `$rest` variable with the value 'giving_circles'.

### Changed
- N/A

### Removed
- N/A

## `/modules/base/controllers/endpoints/Sponsorships.php`

### Added
- Introduced the class `Sponsorships`.
- Added a static variable `$rest`.
- Implemented `__construct` method to initialize the `$rest` variable with the value 'sponsorships'.

### Changed
- N/A

### Removed
- N/A

## `/modules/fundraisers/FundraisersController.php`

### Added
- Introduced the class `FundraisersController`.
- Inherits from `\PureCharity\PcPlugin`.
- Added private variables `$config`, `$controllers`, `$path`.
- Added public variable `$moduleConfig`.
- Implemented `__construct($moduleConfig)` method to set the module configuration, path, and base configuration. Also, autoloads necessary controllers and triggers loader initialization.
- Added private method `autoload()` for WP controller autoloading.
- Added public method `getController($controllerName)` to get specific controller instances.
- Added public method `purecharityPluginTemplate()` to get the path to the Pure Charity plugin template.
- Added public method `purecharityGetTemplates()` to get available templates.

### Changed
- N/A

### Removed
- N/A

## `/modules/fundraisers/controllers/AdminController.php`

### Added
- Introduced the class `AdminController`.
  - Inherits from `FundraisersController`.
- Added constructor method `__construct()`.
  - Module Config is set in the constructor.
  - Plugin Name and version are defined.
- Added public method `addAdminMenu()` to add settings page in WP-Admin.
- Added public method `settingsExist()` to check if settings already exist.
- Added public method `settingsInit()` for initializing settings.
  - Defines all fields required for settings.
- Added callback methods for Settings API.
  - `settingsSectionCallback()`
  - `displaySettingsSectionCallback()`
- Added field rendering methods for:
  - `mainColorRender()`
  - `singleViewTemplateRender()`
  - `liveFilterRender()`
  - `fundraiseCauseRender()`
  - `backersTabRender()`
  - `updatesTabRender()`
  - `daysToGoRender()`
  - `poweredByPureCharityRender()`
  - `organizedByRender()`
- Added public method `optionsPage()` for displaying the options page.

### Changed
- N/A

### Removed
- N/A

### Deprecated
- N/A

### Fixed
- N/A

### Security
- N/A

## `/modules/fundraisers/controllers/I18nController.php`

### Added
- Introduced the class `I18nController`.
  - Inherits from `FundraisersController`.
- Added private variable `$domain`.
- Added public variable `$moduleConfig`.
- Implemented `__construct($moduleConfig)` method to set the module configuration.
- Added public method `loadPluginTextdomain()` for loading the plugin text domain for translation.
  - Utilizes `load_plugin_textdomain()` function.
  - Plugin name and language path are dynamically set from `$moduleConfig`.

### Changed
- N/A

### Removed
- N/A

### Deprecated
- N/A

### Fixed
- N/A

### Security
- N/A

## `/modules/fundraisers/controllers/LoaderController.php`

### Added
- Introduced the class `LoaderController`.
  - Inherits from `FundraisersController`.
- Added private variable `$controllers`.
- Added protected variables `$extendedHooks`, `$actions`, `$filters`.
- Added public variable `$moduleConfig`.
- Implemented `__construct($moduleConfig)` method to set the module configuration, actions, and hooks.
  - Defines extended hooks, actions, and filters arrays.
- Added public method `init($controllers)` to initialize hooks and filters.
  - Calls `initHooks` method for both actions and filters.
- Added private method `initHooks($hooks, $isFilters = false)` to register hooks and filters.
  - Loops through actions and filters to call `add_action` and `add_filter` WordPress functions.

### Changed
- N/A

### Removed
- N/A

### Deprecated
- N/A

### Fixed
- N/A

### Security
- N/A

## `/modules/fundraisers/controllers/PaginatorController.php`

### Added
- Introduced the class `PaginatorController`.
  - Inherits from `FundraisersController`.
- Added public variable `$moduleConfig`.
- Implemented `__construct($moduleConfig)` method to set the module configuration.
- Added constant `DEFAULT_PER_PAGE` for default pagination limit.
- Added public static method `pageLinks($meta = array(), $options = array())` to generate pagination HTML.
  - Uses `sanitizeOptions` and `getQueryParam` methods.
- Added public static method `sanitizeOptions($options)` to sanitize pagination options.
  - Sets default value for 'per_page' if not provided.
- Added public static method `getQueryParam($value_only=false)` to retrieve query parameters.
  - Returns either the query value or the formatted query parameter for URL.

### Changed
- N/A

### Removed
- N/A

### Deprecated
- N/A

### Fixed
- N/A

### Security
- N/A

## `/modules/fundraisers/PublicController.php`

### Added
- Created class `PublicController` inheriting from `FundraisersController`.
- Added private variable `$config` for shortcode configurations.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig` and shortcode configurations.
- Added method `init()` to initialize shortcode registration.
- Added method `registerShortcodes()` to dynamically register WordPress shortcodes.
- Added multiple public static functions (`fundraisersShortcode`, `fundraisersSearchShortcode`, `lastFundraisersShortcode`, `fundraiserShortcode`) to handle different types of shortcodes.

### Changed
- N/A

### Removed
- N/A

## `/modules/fundraisers/ShortcodeController.php`

### Added
- Created class `ShortcodeController` inheriting from `FundraisersController`.
- Added private variable `$config` for shortcode configurations.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig` and shortcode configurations.
- Added method `init()` to initialize shortcode registration.
- Added method `registerShortcodes()` to dynamically register WordPress shortcodes.
- Added multiple public static functions (`fundraisersShortcode`, `fundraisersSearchShortcode`, `lastFundraisersShortcode`, `fundraiserShortcode`) to handle different types of shortcodes.

### Changed
- N/A

### Removed
- N/A

## `/modules/giving-circles/GivingCirclesController.php`

### Added
- Created class `GivingCirclesController` inheriting from `\PureCharity\PcPlugin`.
- Added private variables `$config`, `$controllers`, and `$path`.
- Added public variable `$moduleConfig`.
- Added public static variable `$disableLiveSearch` set to true.
- Implemented `__construct($moduleConfig)` for various initializations.
- Implemented private function `autoload()` to handle controller loading.
- Implemented public function `getController($controllerName)` to fetch controllers.
- Implemented public function `purecharityPluginTemplate()` to fetch template configuration.
- Implemented public function `purecharityGetTemplates()` to fetch templates.

### Changed
- N/A

### Removed
- N/A

## `/modules/giving-circles/controllers/AdminController.php`

### Added
- Created class `AdminController` inheriting from `GivingCirclesController`.
- Added private variables `$version` and `$pluginName`.
- Added public variable `$moduleConfig`.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig`, `$pluginName`, and `$version`.
- Added method `addAdminMenu()` for admin menu options.
- Added method `settingsExist()` to check for settings existence.
- Added method `settingsInit()` to initialize settings.
- Added multiple static functions for rendering settings (`mainColorRender`, `roundAvatarsRender`, `singleViewTemplateRender`).
- Added method `optionsPage()` to create the options page.
- Added method `settingsSectionCallback()` for the settings callback.

### Changed
- N/A

### Removed
- N/A

## `/modules/giving-circles/controllers/I18nController.php`

### Added
- Created class `I18nController` inheriting from `GivingCirclesController`.
- Added public variable `$moduleConfig`.
- Added private variable `$domain`.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig`.
- Added method `loadPluginTextdomain()` for loading plugin text domain for translation.

### Changed
- N/A

### Removed
- N/A

## `/modules/giving-circles/controllers/LoaderController.php`

### Added
- Created class `LoaderController` inheriting from `GivingCirclesController`.
- Added public variable `$moduleConfig`.
- Added private variable `$controllers`.
- Added protected variables `$extendedHooks`, `$actions`, and `$filters`.
- Implemented `__construct($moduleConfig)` for initializing configurations and hooks.
- Added `init($controllers)` method for initializing controllers and their hooks.
- Added private method `initHooks($hooks, $isFilters = false)` for adding actions and filters based on the configuration.

### Changed
- N/A

### Removed
- Commented out code related to `admin_enqueue_scripts` and `wp_ajax`.

## `/modules/giving-circles/controllers/PublicController.php`

### Added
- Created class `PublicController` inheriting from `GivingCirclesController`.
- Added public variables `$moduleConfig`, `\$options`, `\$givingcircle`, `\$givingcircles`.
- Added private variables `$version` and `$pluginName`.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for setting initial configurations.
- Added method `enqueueStyles()` to handle the stylesheets for the dashboard.
- Added `listNotFound()` method for displaying a "not found" message when no Giving Circles are found.

### Changed
- N/A

### Removed
- N/A

## `/modules/giving-circles/controllers/ShortcodeController.php`

### Added
- Created class `ShortcodeController` inheriting from `GivingCirclesController`.
- Added public variable `$moduleConfig`.
- Added private variable `$config`.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for setting initial configurations.
- Added method `init()` to initialize the class.
- Added method `registerShortcodes()` to handle shortcode registrations.
- Added method `givingCirclesShortcode($atts)` to handle the `[giving_circles]` shortcode logic.
- Added placeholders for `givingCircleShortcode($atts)` and `givingCircleInfoShortcode($atts)` methods, which are still to be implemented.

### Changed
- N/A

### Removed
- N/A

## `/modules/sponsorships/SponsorshipsController.php`

### Added
- Created class `SponsorshipsController` inheriting from `\PureCharity\PcPlugin`.
- Added private variables `$config`, `$controllers`, and `$path`.
- Added public variable `$moduleConfig`.
- Implemented `__construct($moduleConfig)` for initial setup including autoloading controllers and triggering Loader Initialization.
- Added `autoload()` private function to dynamically load controllers based on the `$config` setting.
- Added `getController($controllerName)` method to fetch a specific controller instance.
- Added `purecharityPluginTemplate()` and `purecharityGetTemplates()` methods for template management.

### Changed
- N/A

### Removed
- N/A

## `/modules/sponsorships/controllers/AdminController.php`

### Added
- Created class `AdminController` inheriting from `SponsorshipsController`.
- Added private variables `$version` and `$pluginName`.
- Added public variable `$moduleConfig`.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig`, `$pluginName`, and `$version`.
- Added method `addAdminMenu()` for admin menu options.
- Added method `settingsExist()` to check for settings existence.
- Added method `settingsInit()` to initialize settings.
- Added multiple static functions for rendering settings (`mainColorRender`, `roundAvatarsRender`, `singleViewTemplateRender`).
- Added method `optionsPage()` to create the options page.
- Added method `settingsSectionCallback()` for the settings callback.

### Changed
- N/A

### Removed
- N/A

## `/modules/sponsorships/controllers/I18nController.php`

### Added
- Created class `I18nController` inheriting from `SponsorshipsController`.
- Added public variable `$moduleConfig` for module configurations.
- Added private variable `$domain`.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig`.
- Added method `loadPluginTextdomain()` to load the plugin text domain for translation.

### Changed
- N/A

### Removed
- N/A

## `/modules/sponsorships/controllers/LoaderController.php`

### Added
- Created class `LoaderController` inheriting from `SponsorshipsController`.
- Added public variable `$moduleConfig` for module configurations.
- Added private variable `$controllers`.
- Added protected variables `$extendedHooks`, `$actions`, and `$filters`.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig` and initializing extended hooks, actions, and filters.
- Added method `init($controllers)` to initialize hooks and filters.
- Added private method `initHooks($hooks, $isFilters)` to handle the WordPress hooks.

### Changed
- N/A

### Removed
- N/A

## `/modules/sponsorships/controllers/PaginatorController.php`

### Added
- Created class `PaginatorController` inheriting from `SponsorshipsController`.
- Added public variable `$moduleConfig` for module configurations.
- Defined constant `DEFAULT_PER_PAGE` set to 10.
- Implemented `__construct($moduleConfig)` for setting up `$moduleConfig`.
- Added static method `pageLinks($meta = array(), $options = array())` to generate pagination links.
- Added static method `sanitizeOptions($options)` to sanitize the pagination options.

### Changed
- N/A

### Removed
- N/A

## `/modules/sponsorships/controllers/PublicController.php`

### Added
- Created class `PublicController` inheriting from `SponsorshipsController`.
- Added public variables `$moduleConfig`, `\$sponsorship`, `\$sponsorships`, `\$sponsorshipsFull`.
- Added private variables `$version` and `$pluginName`.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for setting initial configurations.
- Added method `enqueueStyles()` to register the stylesheets for the Dashboard and handle module resources.
- Added static method `listing()` to generate the HTML for listing sponsorships, including pagination and "Powered By" footer.
- Added static method `single()` to generate the HTML for listing single sponsorship, including pagination and "Powered By" footer.\
- Added static method `renderSlots()`.
- Added static method `renderDescription()`.
- Added static method `renderAge()`.
- Added static method `renderAboutSection()`.
- Added static method `lowerListingContent()`.
- Added static method `resetFilter()`.
- Added static method `ageFilter()`.
- Added static method `genderFilter()`.
- Added static method `locationFilter()`.
- Added static method `theBullets()`.
- Added static method `customCss()`.
- Added static method `sponsorshipSlotsText()`.
- Added static method `lowerLinks()`.
- Added static method `renderCustomFields()`.
- Added static method `renderSponsorOptions()`.
- Added static method `searchInput()`.
- Added method `sniffRequests()`.
- Added protected method `handleRequest()`.
- Added protected method `sendResponse()`.
- Added public method `addQueryVars()`.
- Added public method `ssForceTemplate()`.
- Added public method `sponsorshipsLazyLoading()`.
- Added public method `getSponsorshipsFromCache()`.
- Added public method `getListing()`.
- Added public method `setSponsorshipsCache()`.
- Added public method `getLocationsFromCache()`.
- Added public method `setLocationsCache()`.
- Added public method `setLocationsCache()`.

### Changed
- N/A

### Removed
- N/A

## `/modules/trips/TripsController.php`

### Added
- Created class `TripsController` inheriting from `PcPlugin`.
- Added private variables `$config`, `$controllers`, and `$path`.
- Added public variables `$moduleConfig` and static variable `$disableLiveSearch`.
- Implemented `__construct($moduleConfig)` for initializing module configurations.
- Added method `autoload()` for automatically loading WordPress controllers.
- Added method `getController($controllerName)` for retrieving controller instances.
- Added method `purecharityPluginTemplate()` for setting up the template page.
- Added method `purecharityGetTemplates()` for retrieving templates.

### Changed
- N/A

### Removed
- N/A

## `/modules/trips/controllers/AdminController.php`

### Added
- Created class `AdminController` inheriting from `TripsController`.
- Added public variable `$moduleConfig` and private variables `$version`, `$pluginName`.
- Added public static variable `$classPath`.
- Implemented `__construct($moduleConfig)` for initializing module configurations.
- Added method `addAdminMenu()` for adding options to the WordPress admin menu.
- Added method `settingsExist()` to check for the existence of settings.
- Added method `settingsInit()` to initialize settings page options.
- Added method `mainColorRender()` for rendering the color picker.
- Added method `settingsSectionCallback()` as a callback for settings.
- Added method `optionsPage()` for creating the settings page.
- Added method `liveFilterRender()` for rendering the live filter checkbox.
- Added method `singleViewTemplateRender()` for rendering the single view template selector.

### Changed
- N/A

### Removed
- N/A

## `/modules/trips/controllers/I18nController.php`

### Added
- Created class `I18nController` inheriting from `TripsController`.
- Added public variable `$moduleConfig` and private variable `$domain`.
- Implemented `__construct($moduleConfig)` for initializing module configurations.
- Added method `loadPluginTextdomain()` for loading the plugin text domain for translation.

### Changed
- N/A

### Removed
- N/A

## `/modules/trips/controllers/LoaderController.php`

### Added
- Created class `LoaderController` inheriting from `TripsController`.
- Added public variable `$moduleConfig` and private variable `$controllers`.
- Added protected variables `$extendedHooks`, `$actions`, and `$filters`.
- Implemented `__construct($moduleConfig)` for initializing module configurations, actions, and extended hooks.
- Added method `init($controllers)` for initializing controllers and hooks.
- Added method `initHooks($hooks, $isFilters = false)` for adding WordPress actions and filters dynamically based on the provided hooks.

### Changed
- N/A

### Removed
- N/A

## `/modules/trips/controllers/PaginatorController.php`

### Added
- Created class `PaginatorController` inheriting from `TripsController`.
- Added public variable `$moduleConfig`.
- Added class constant `DEFAULT_PER_PAGE` set to 10.
- Implemented `__construct($moduleConfig)` for initializing module configurations.
- Added method `pageLinks($meta = array(), $options = array())` for generating pagination links.
- Added method `sanitizeOptions($options)` to sanitize and validate pagination options.

### Changed
- N/A

### Removed
- N/A

## `/modules/trips/controllers/ShortcodeController.php`

### Added
- Added a new public variable `$moduleConfig` to hold module configurations.
- Added a private `$config` variable to store the configuration for shortcodes.
- Implemented `__construct()` for initializing `$moduleConfig` and calling `init()`.
- Added `init()` method for registering WordPress shortcodes.
- Added `registerShortcodes()` method for dynamic shortcode registration.
- Added `tripsShortcode($atts)` method for implementing the trips shortcode.
- Added `tripShortcode($atts)` method for implementing the single trip shortcode.
- Added `tripsFiltersShortcode($atts)` method for implementing trips filters shortcode.
- Added `filteredOpts($opts = [], $convertKeyMap = [])` method for filtering options.

### Changed
- N/A

### Removed
- N/A

## `/resources/src/scripts/admin/core.js`

### Added
- Initialized `window.andromedaAutoloadDependencies` as an empty array for managing script dependencies.
- Defined `window.breakpoints` for responsive design breakpoints.
- Defined `window.autoload` for registering and initializing script components.
- Added `window.scriptsDir` to store the scripts directory from `pcPublicConfig`.
- Implemented `window.loadScript(element)` for loading individual scripts.
- Implemented `window.loadDependencyScript(dependency, id)` for handling script dependencies.

### Changed
- N/A

### Removed
- N/A

## `/resources/src/scripts/admin/autoload/base.js`

### Added
- Created `PcBase` class.
- Defined `init()` method to initialize selectors and call `initColorPicker()`.
- Added `this.selectors` object to manage jQuery selectors, such as `colorPicker`.
- Implemented `initColorPicker()` method to initialize the color picker functionality using jQuery and Spectrum.

### Changed
- N/A

### Removedz
- N/A

## `/resources/src/scripts/admin/autoload/sponsorships.js`

### Added
- Created `PcSponsorships` class with `init()` method.
- Implemented `prepareDomElements`, `initDefaults`, `initSortable`, `initEventHandlers`, and `saveCustomField` methods.
- Added complex configuration object `this.config` to handle selectors, markup, and other settings.
- Added DOM manipulation and event handling functionalities.

### Changed
- Introduced the `prepareDomElements` method for selector management, reducing direct jQuery calls.
- Used `initDefaults` to handle default settings, enhancing maintainability.

### Removed
- N/A

## `/resources/src/scripts/public/core.js`

### Added
- Introduced `window.andromedaAutoloadDependencies` array for dependency management.
- Defined `window.breakpoints` object for responsive breakpoints.
- Initialized `window.autoload` array for script auto-loading with conditions specified via `loadWhen` functions.
- Added `window.loadScript(element)` function to handle asynchronous script loading.
- Implemented `window.loadDependencyScript(dependency, id)` for loading dependent scripts.

### Changed
- Wrapped script-loading logic inside `window.addEventListener('load', (event) => {...})`.

### Removed
- N/A

## `/resources/src/scripts/public/autoload/base.js`

### Added
- Introduced `PcPublicBase` class.
- Defined an empty `init()` method within `PcPublicBase`.
- Instantiated `window.PcPublicBase` as a new object of `PcPublicBase` class.

### Changed
- N/A

### Removed
- N/A

## `/resources/src/scripts/public/autoload/fundraisers.js`

### Added
- Introduced `PcFundraisers` class.
- Defined `init()` method to initialize selectors and call `initEventHandlers()`.
- Added `this.selector` object to manage jQuery selectors, such as `clearFilter` under `button`.
- Implemented `initEventHandlers()` method to initialize event handlers for clear filter functionality.
- Defined `handleClearFilter(event)` method to handle the action of clearing filters, updates the window location URL.

### Changed
- N/A

### Removed
- N/A

## `/resources/src/scripts/public/autoload/trips.js`

### Added
- Introduced `PcTrips` class containing various methods for trip filtering.
- Added `init()` method for initialization.
- Implemented `prepareSelectorClass()` for selector class formatting.
- Created `initEventHandlers()` for binding events to DOM elements.
- Added methods for state management: `setFilterOptionChangeState()`, `getFilterOptionChangeState()`.
- Implemented `handleFilterOptionChanged()`, `handlePageButton()`, `handleResetFilters()`, `handleSubmitLiveSearchFilters()`, and `handleSubmitFilters()` for event handling.

### Changed
- Optimized selector and class preparation logic.
- Utilized `jQuery` for DOM manipulation and AJAX handling.

### Removed
- N/A

## `/resources/src/styles/admin/_global.scss`

### Added
- Introduced CSS rules for dashboard-specific functionality.
- Added styling for `form.pure-settings-form select` and `form.pure-settings-form input[type="text"]` to set `max-width` to 400px and `width` to 100%.

### Changed
- N/A

### Removed
- N/A

## `/resources/src/styles/admin/_sponsorships.scss`

### Added
- Introduced CSS rules for dashboard-specific functionality under `.pcs_custom_field` class.
- Added `list-style`, `margin` properties for `.pcs_custom_field`.
- Created `.pcs_custom_field.header` class with properties like `border-top`, `background`, `font-size`, and `margin-top`.
- Defined `.pcs_custom_field li` with properties for `border`, `border-top`, `background`, `padding`, and `margin`.
- Added `.pcs_custom_field li .left`, `.pcs_custom_field li .right`, and `.pcs_custom_field li .options` for layout control.
- Implemented `.pcs_custom_field li input` and `.pcs_custom_field li .save` to control display.

### Changed
- N/A

### Removed
- N/A

## `/resources/src/styles/admin/admin.scss`

### Added
- Imported dependency `./spectrum` for color picker functionality.
- Imported global styles from `./global`.
- Imported module styles from `./sponsorships`.

### Changed
- N/A

### Removed
- N/A